/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec;

import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.exec.ActionInvocation;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.IExecuteInterceptor;
import com.qlangtech.tis.exec.datax.DataXExecuteInterceptor;
import com.qlangtech.tis.exec.impl.DefaultChainContext;
import com.qlangtech.tis.exec.impl.TrackableExecuteInterceptor;
import com.qlangtech.tis.exec.impl.WorkflowDumpAndJoinInterceptor;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractActionInvocation
implements ActionInvocation {
    public static final String COMMAND_KEY_DIRECTBUILD = "directbuild";
    private static final Logger logger = LoggerFactory.getLogger(AbstractActionInvocation.class);
    public static final IExecuteInterceptor[] dataXBuild = new IExecuteInterceptor[]{new DataXExecuteInterceptor()};
    private ComponentOrders componentOrders;
    private IExecChainContext chainContext;
    private IExecuteInterceptor interceptor;
    private ActionInvocation successor;

    public static ActionInvocation createExecChain(DefaultChainContext chainContext) throws Exception {
        IExecuteInterceptor[] ints = null;
        if (!chainContext.hasIndexName() && chainContext.getWorkflowId() != null) {
            ints = new IExecuteInterceptor[]{new WorkflowDumpAndJoinInterceptor()};
        } else if (chainContext.hasIndexName()) {
            ints = dataXBuild;
        } else {
            throw new UnsupportedOperationException();
        }
        Integer taskid = chainContext.getTaskId();
        TrackableExecuteInterceptor.initialTaskPhase(taskid);
        return AbstractActionInvocation.createInvocation(chainContext, ints);
    }

    public static ActionInvocation createInvocation(IExecChainContext chainContext, IExecuteInterceptor[] ints) {
        ComponentOrders componentOrders = new ComponentOrders();
        AbstractActionInvocation preInvocation = new AbstractActionInvocation();
        preInvocation.setContext(chainContext);
        preInvocation.setComponentOrders(componentOrders);
        AbstractActionInvocation invocation = null;
        for (int i = ints.length - 1; i >= 0; --i) {
            for (FullbuildPhase phase : ints[i].getPhase()) {
                componentOrders.put(phase, i);
            }
            invocation = new AbstractActionInvocation();
            invocation.setComponentOrders(componentOrders);
            invocation.setContext(chainContext);
            invocation.setInterceptor(ints[i]);
            invocation.setSuccessor(preInvocation);
            preInvocation = invocation;
        }
        logger.info("component description:");
        for (Map.Entry<FullbuildPhase, Integer> componentEntry : componentOrders.entrySet()) {
            logger.info(componentEntry.getKey() + ":" + componentEntry.getValue());
        }
        logger.info("description end");
        return preInvocation;
    }

    @Override
    public ExecuteResult invoke() throws Exception {
        int current;
        if (this.componentOrders == null) {
            throw new IllegalStateException("componentOrders can not be null");
        }
        ExecutePhaseRange phaseRange = this.chainContext.getExecutePhaseRange();
        int startIndex = Integer.MIN_VALUE;
        int endIndex = Integer.MAX_VALUE;
        startIndex = this.componentOrders.get(phaseRange.getStart());
        endIndex = this.componentOrders.get(phaseRange.getEnd());
        if (this.interceptor == null) {
            return ExecuteResult.SUCCESS;
        }
        try {
            current = this.componentOrders.get(FullbuildPhase.getFirst(this.interceptor.getPhase()));
        }
        catch (Throwable e) {
            throw new IllegalStateException("component:" + FullbuildPhase.desc(this.interceptor.getPhase()) + " can not find value in componentOrders," + this.componentOrders.toString());
        }
        if (current >= startIndex && current <= endIndex) {
            logger.info("execute " + FullbuildPhase.desc(this.interceptor.getPhase()) + ":" + current + "[" + startIndex + "," + endIndex + "]");
            return this.interceptor.intercept(this.successor);
        }
        return this.successor.invoke();
    }

    public ComponentOrders getComponentOrders() {
        return this.componentOrders;
    }

    public void setComponentOrders(ComponentOrders componentOrders) {
        this.componentOrders = componentOrders;
    }

    @Override
    public IExecChainContext getContext() {
        return this.chainContext;
    }

    public void setSuccessor(ActionInvocation successor) {
        this.successor = successor;
    }

    public IExecuteInterceptor getSuccessor() {
        return this.interceptor;
    }

    public void setInterceptor(IExecuteInterceptor successor) {
        this.interceptor = successor;
    }

    public void setContext(IExecChainContext action) {
        this.chainContext = action;
    }

    public static class ComponentOrders {
        private final Map<FullbuildPhase, Integer> orders = Maps.newHashMap();

        public Integer get(FullbuildPhase key) {
            Integer index = this.orders.get(key);
            if (index == null) {
                throw new IllegalStateException("key:" + key + " can not find relevant map keys[" + this.orders.keySet().stream().map(r -> r.getName()).collect(Collectors.joining(",")) + "]");
            }
            return index;
        }

        public Set<Map.Entry<FullbuildPhase, Integer>> entrySet() {
            return this.orders.entrySet();
        }

        public Integer put(FullbuildPhase key, Integer value) {
            return this.orders.put(key, value);
        }
    }
}

