/*
 * Decompiled with CFR 0.152.
 */
package com.tis.hadoop.rpc;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.realtime.yarn.rpc.IncrStatusUmbilicalProtocol;
import com.qlangtech.tis.realtime.yarn.rpc.LaunchReportInfo;
import com.qlangtech.tis.realtime.yarn.rpc.MasterJob;
import com.qlangtech.tis.realtime.yarn.rpc.PingResult;
import com.qlangtech.tis.realtime.yarn.rpc.UpdateCounterMap;
import com.qlangtech.tis.rpc.grpc.log.DefaultLoggerAppenderClient;
import com.qlangtech.tis.rpc.grpc.log.ILogReporter;
import com.qlangtech.tis.rpc.grpc.log.ILoggerAppenderClient;
import com.qlangtech.tis.rpc.grpc.log.LogCollectorClient;
import com.qlangtech.tis.rpc.grpc.log.stream.PMonotorTarget;
import com.qlangtech.tis.rpc.grpc.log.stream.PPhaseStatusCollection;
import com.qlangtech.tis.rpc.server.IncrStatusClient;
import com.qlangtech.tis.solrj.util.ZkUtils;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.tis.hadoop.rpc.AdapterAssembleSvcCompsiteCallback;
import com.tis.hadoop.rpc.GrpcConnectionException;
import com.tis.hadoop.rpc.ITISRpcService;
import com.tis.hadoop.rpc.RpcServiceReference;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusRpcClientFactory {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(.+?):(\\d+)$");
    private static final Logger logger = LoggerFactory.getLogger(StatusRpcClientFactory.class);
    private static RpcServiceReference instance;
    private static final ExecutorService reConnectSchedule;

    private StatusRpcClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RpcServiceReference getService(ITISCoordinator zookeeper, AdapterAssembleSvcCompsiteCallback ... callbacks) throws Exception {
        if (instance != null) return instance;
        Class<StatusRpcClientFactory> clazz = StatusRpcClientFactory.class;
        synchronized (StatusRpcClientFactory.class) {
            if (instance != null) return instance;
            StatusRpcClientFactory clientFactory = new StatusRpcClientFactory();
            AssembleSvcCompsite.statusRpc = instance = clientFactory.connect2RemoteIncrStatusServer(zookeeper, callbacks);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private void connect2RemoteIncrStatusServer(ITISCoordinator zookeeper, boolean reConnect, AssembleSvcCompsiteCallback rpcCallback) {
        String incrStateCollectAddress = ZkUtils.getFirstChildValue((ITISCoordinator)zookeeper, (String)"/tis/incr-transfer-group/incr-state-collect", (boolean)reConnect);
        this.connect2RemoteIncrStatusServer(incrStateCollectAddress, rpcCallback);
    }

    private ITISRpcService connect2RemoteIncrStatusServer(String incrStateCollectAddress, AssembleSvcCompsiteCallback rpcCallback) {
        Matcher matcher = ADDRESS_PATTERN.matcher(incrStateCollectAddress);
        if (!matcher.matches()) {
            throw new IllegalStateException("incrStatusRpcServer:" + incrStateCollectAddress + " is not match the pattern:" + ADDRESS_PATTERN);
        }
        InetSocketAddress address = new InetSocketAddress(matcher.group(1), Integer.parseInt(matcher.group(2)));
        StatusRpcClientFactory.info("status server address:" + address);
        ITISRpcService oldRpc = rpcCallback.getOld();
        try {
            if (oldRpc != null) {
                oldRpc.close();
            }
            final ManagedChannel channel = ManagedChannelBuilder.forTarget((String)incrStateCollectAddress).usePlaintext().build();
            IncrStatusClient newRpc = new IncrStatusClient((Channel)channel);
            LogCollectorClient logCollectorClient = new LogCollectorClient(channel);
            DefaultLoggerAppenderClient loggerAppenderClient = new DefaultLoggerAppenderClient(channel);
            StatusRpcClientFactory.info("successful connect to " + address + ",pingResult:" + newRpc.ping());
            return rpcCallback.process(oldRpc, new AssembleSvcCompsite(newRpc, logCollectorClient, loggerAppenderClient){

                @Override
                public void close() {
                    try {
                        channel.shutdownNow().awaitTermination(2L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            StatusRpcClientFactory.error(e.getMessage(), e);
            rpcCallback.errorOccur(oldRpc, e);
            return null;
        }
    }

    public static RpcServiceReference getMockStub() {
        AtomicReference<AssembleSvcCompsite> ref = new AtomicReference<AssembleSvcCompsite>();
        ref.set(AssembleSvcCompsite.MOCK_PRC);
        return new RpcServiceReference(ref, (ITISRpcService)AssembleSvcCompsite.MOCK_PRC, () -> {});
    }

    private RpcServiceReference connect2RemoteIncrStatusServer(ITISCoordinator zookeeper, AdapterAssembleSvcCompsiteCallback ... callbacks) throws Exception {
        RpcServiceReference svcRef = StatusRpcClientFactory.getMockStub();
        if (!zookeeper.shallConnect2RemoteIncrStatusServer()) {
            logger.warn("shallConnect2RemoteIncrStatusServer= false");
            return svcRef;
        }
        TryConnection connect = new TryConnection(zookeeper, svcRef.getRef(), callbacks);
        connect.run();
        StatusRpcClientFactory.startConnect2RPC(connect);
        return new RpcServiceReference(svcRef.getRef(), (ITISRpcService)AssembleSvcCompsite.MOCK_PRC, (Runnable)connect);
    }

    private static void startConnect2RPC(TryConnection connect) {
        AtomicInteger tryCount = new AtomicInteger();
        reConnectSchedule.submit(() -> {
            while (true) {
                logger.info("start reconnect rpc server,tryCount:" + tryCount.incrementAndGet());
                TryConnection tryConnection = connect;
                synchronized (tryConnection) {
                    if (connect.successConnected.get()) {
                        connect.wait();
                        logger.info("reconnect process was notify,tryCount:" + tryCount.incrementAndGet());
                    }
                }
                connect.run();
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void main(String[] args) {
    }

    private static void info(String msg) {
        System.out.println(msg);
    }

    private static void error(String msg, Throwable e) {
        StatusRpcClientFactory.info("err:" + msg);
        if (e != null) {
            StatusRpcClientFactory.info(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("dataX ShutdownHook"){

            @Override
            public void run() {
                if (instance == null) {
                    return;
                }
                try {
                    ITISRpcService rpcService = (ITISRpcService)instance.getRef().get();
                    if (rpcService != null) {
                        rpcService.close();
                    }
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                }
            }
        });
        reConnectSchedule = Executors.newSingleThreadExecutor();
    }

    private static class MockIncrStatusUmbilicalProtocol
    implements IncrStatusUmbilicalProtocol,
    Closeable {
        private MockIncrStatusUmbilicalProtocol() {
        }

        public void nodeLaunchReport(LaunchReportInfo launchReportInfo) {
        }

        public PhaseStatusCollection loadPhaseStatusFromLatest(Integer taskId) {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        public void initSynJob(PhaseStatusCollection buildStatus) {
        }

        public void reportJoinStatus(Integer taskId, JoinPhaseStatus.JoinTaskStatus joinTaskStatus) {
        }

        public PingResult ping() {
            PingResult pingResult = new PingResult();
            pingResult.setValue(pingResult.getValue() + " from mock");
            return pingResult;
        }

        public MasterJob reportStatus(UpdateCounterMap upateCounter) {
            logger.warn("stat report server has not connect on!!!! using Mock channel");
            return null;
        }

        public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
        }

        public void reportBuildIndexStatus(BuildSharedPhaseStatus buildStatus) {
        }
    }

    public static class MockLogReporter
    implements ILogReporter {
        @Override
        public StreamObserver<PMonotorTarget> registerMonitorEvent(ILogListener logListener) {
            return new NoopStreamObserver<PMonotorTarget>();
        }

        @Override
        public Iterator<PPhaseStatusCollection> buildPhraseStatus(Integer taskid) {
            return Iterators.forArray((Object[])new PPhaseStatusCollection[0]);
        }
    }

    public static class NoopStreamObserver<V>
    implements StreamObserver<V> {
        public void onNext(V value) {
        }

        public void onError(Throwable t) {
        }

        public void onCompleted() {
        }
    }

    public static abstract class AssembleSvcCompsite
    implements ITISRpcService {
        public static RpcServiceReference statusRpc;
        private final IncrStatusUmbilicalProtocol statReceiveSvc;
        private final ILoggerAppenderClient loggerAppenderClient;
        private final ILogReporter statReportSvc;
        public static final AssembleSvcCompsite MOCK_PRC;

        public AssembleSvcCompsite(IncrStatusUmbilicalProtocol statReceiveSvc, ILogReporter statReportSvc, ILoggerAppenderClient loggerAppenderClient) {
            Objects.requireNonNull(statReceiveSvc, "param statReceiveSvc can not be null");
            Objects.requireNonNull(statReportSvc, "param statReportSvc can not be null");
            Objects.requireNonNull(loggerAppenderClient, "param loggerAppenderClient can not be null");
            this.statReceiveSvc = statReceiveSvc;
            this.statReportSvc = statReportSvc;
            this.loggerAppenderClient = loggerAppenderClient;
        }

        public AssembleSvcCompsite unwrap() {
            return this;
        }

        public abstract void close();

        public PhaseStatusCollection loadPhaseStatusFromLatest(Integer taskId) {
            return this.invokeGrpc(() -> this.statReceiveSvc.loadPhaseStatusFromLatest(taskId));
        }

        private <T> T invokeGrpc(Supplier<T> supplier) {
            try {
                return supplier.get();
            }
            catch (StatusRuntimeException e) {
                throw new GrpcConnectionException((Throwable)e);
            }
        }

        public void append(Map<String, String> headers, ILoggerAppenderClient.LogLevel level, String body) {
            this.invokeGrpc(() -> {
                this.loggerAppenderClient.append(headers, level, body);
                return null;
            });
        }

        public final void appendLog(ILoggerAppenderClient.LogLevel level, Integer taskId, Optional<String> appName, String message) {
            HashMap headers = Maps.newHashMap();
            headers.put("taskid", String.valueOf(taskId));
            headers.put("app", appName.orElse("unknow"));
            headers.put("logtype", "fullbuild");
            this.append(headers, level, message);
        }

        public StreamObserver<PMonotorTarget> registerMonitorEvent(ILogListener logListener) {
            return this.invokeGrpc(() -> this.statReportSvc.registerMonitorEvent(logListener));
        }

        public Iterator<PPhaseStatusCollection> buildPhraseStatus(Integer taskid) {
            return this.invokeGrpc(() -> this.statReportSvc.buildPhraseStatus(taskid));
        }

        public PingResult ping() {
            return this.invokeGrpc(() -> this.statReceiveSvc.ping());
        }

        public MasterJob reportStatus(UpdateCounterMap upateCounter) {
            return this.invokeGrpc(() -> this.statReceiveSvc.reportStatus(upateCounter));
        }

        public void reportJoinStatus(Integer taskId, JoinPhaseStatus.JoinTaskStatus joinStatus) {
            this.invokeGrpc(() -> {
                this.statReceiveSvc.reportJoinStatus(taskId, joinStatus);
                return null;
            });
        }

        public void nodeLaunchReport(LaunchReportInfo launchReportInfo) {
            this.invokeGrpc(() -> {
                this.statReceiveSvc.nodeLaunchReport(launchReportInfo);
                return null;
            });
        }

        public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
            this.invokeGrpc(() -> {
                this.statReceiveSvc.reportDumpTableStatus(tableDumpStatus);
                return null;
            });
        }

        public void reportBuildIndexStatus(BuildSharedPhaseStatus buildStatus) {
            this.invokeGrpc(() -> {
                this.statReceiveSvc.reportBuildIndexStatus(buildStatus);
                return null;
            });
        }

        public void initSynJob(PhaseStatusCollection buildStatus) {
            this.invokeGrpc(() -> {
                this.statReceiveSvc.initSynJob(buildStatus);
                return null;
            });
        }

        static {
            MOCK_PRC = new AssembleSvcCompsite(new MockIncrStatusUmbilicalProtocol(), new MockLogReporter(), new ILoggerAppenderClient(){

                public void append(Map<String, String> headers, ILoggerAppenderClient.LogLevel level, String body) {
                    logger.warn("rpc msg write to mock instance,taskId:" + headers.get("taskid"));
                }
            }){

                @Override
                public void close() {
                }

                @Override
                public AssembleSvcCompsite unwrap() {
                    return this;
                }
            };
            AtomicReference<AssembleSvcCompsite> ref = new AtomicReference<AssembleSvcCompsite>();
            ref.set(MOCK_PRC);
            statusRpc = new RpcServiceReference(ref, (ITISRpcService)MOCK_PRC, () -> {});
        }
    }

    public static interface AssembleSvcCompsiteCallback {
        public ITISRpcService process(ITISRpcService var1, ITISRpcService var2);

        public ITISRpcService getOld();

        public void errorOccur(ITISRpcService var1, Exception var2);
    }

    public static class TryConnection
    implements Runnable {
        private ITISCoordinator zookeeper;
        private AtomicReference<ITISRpcService> ref;
        AtomicBoolean successConnected = new AtomicBoolean(false);
        AdapterAssembleSvcCompsiteCallback[] callbacks;
        private final ReentrantLock tryConnectLock = new ReentrantLock();

        public TryConnection(ITISCoordinator zookeeper, AtomicReference<ITISRpcService> ref, AdapterAssembleSvcCompsiteCallback[] callbacks) {
            this.zookeeper = zookeeper;
            this.ref = ref;
            this.callbacks = callbacks;
        }

        @Override
        public void run() {
            if (this.tryConnectLock.tryLock()) {
                try {
                    StatusRpcClientFactory statusRpcClient = new StatusRpcClientFactory();
                    statusRpcClient.connect2RemoteIncrStatusServer(this.zookeeper, true, new AssembleSvcCompsiteCallback(){

                        @Override
                        public ITISRpcService process(ITISRpcService oldrpc, ITISRpcService newrpc) {
                            ref.compareAndSet(oldrpc, newrpc);
                            successConnected.set(true);
                            for (AdapterAssembleSvcCompsiteCallback c : callbacks) {
                                c.process(oldrpc, newrpc);
                            }
                            return newrpc;
                        }

                        @Override
                        public ITISRpcService getOld() {
                            return (ITISRpcService)ref.get().unwrap();
                        }

                        @Override
                        public void errorOccur(ITISRpcService oldrpc, Exception e) {
                            ref.compareAndSet(oldrpc, AssembleSvcCompsite.MOCK_PRC);
                            successConnected.set(false);
                        }
                    });
                }
                finally {
                    this.tryConnectLock.unlock();
                }
            }
        }
    }
}

