/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrStatusServer {
    private static final Logger logger = LoggerFactory.getLogger(IncrStatusServer.class);
    private final int port;
    private ServerBuilder<?> serverBuilder;
    private Server server;

    public IncrStatusServer(int port) throws IOException {
        this(ServerBuilder.forPort((int)port), port);
    }

    public IncrStatusServer(ServerBuilder<?> serverBuilder, int port) {
        this.port = port;
        this.serverBuilder = serverBuilder;
    }

    public void addService(BindableService bindSvc) {
        this.serverBuilder.addService(bindSvc);
    }

    public void start() throws IOException {
        this.server = this.serverBuilder.build();
        this.server.start();
        logger.info("Server started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                try {
                    IncrStatusServer.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                System.err.println("*** server shut down");
            }
        });
    }

    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws Exception {
        IncrStatusServer server = new IncrStatusServer(8980);
        server.start();
        server.blockUntilShutdown();
    }
}

