/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.server;

import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.fullbuild.phasestatus.JobLog;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.grpc.IncrStatusGrpc;
import com.qlangtech.tis.grpc.LaunchReportInfo;
import com.qlangtech.tis.grpc.LaunchReportInfoEntry;
import com.qlangtech.tis.grpc.MasterJob;
import com.qlangtech.tis.grpc.TableSingleDataIndexStatus;
import com.qlangtech.tis.grpc.TopicInfo;
import com.qlangtech.tis.grpc.UpdateCounterMap;
import com.qlangtech.tis.realtime.yarn.rpc.IncrStatusUmbilicalProtocol;
import com.qlangtech.tis.realtime.yarn.rpc.JobType;
import com.qlangtech.tis.realtime.yarn.rpc.LaunchReportInfo;
import com.qlangtech.tis.realtime.yarn.rpc.MasterJob;
import com.qlangtech.tis.realtime.yarn.rpc.PingResult;
import com.qlangtech.tis.realtime.yarn.rpc.PipelineFlinkTaskId;
import com.qlangtech.tis.realtime.yarn.rpc.TopicInfo;
import com.qlangtech.tis.rpc.grpc.log.LogCollectorClient;
import com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.common.Empty;
import com.qlangtech.tis.rpc.grpc.log.common.JobLog;
import com.qlangtech.tis.rpc.grpc.log.common.JoinTaskStatus;
import com.qlangtech.tis.rpc.grpc.log.common.TableDumpStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.LogCollectorGrpc;
import com.qlangtech.tis.rpc.grpc.log.stream.PBuildPhaseStatusParam;
import com.qlangtech.tis.rpc.grpc.log.stream.PPhaseStatusCollection;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrStatusClient
implements IncrStatusUmbilicalProtocol {
    private static final Logger logger = LoggerFactory.getLogger(IncrStatusClient.class);
    private final IncrStatusGrpc.IncrStatusBlockingStub blockingStub;
    private final IncrStatusGrpc.IncrStatusStub asyncStub;
    private final LogCollectorGrpc.LogCollectorBlockingStub logCollectorBlockingStub;

    public IncrStatusClient(Channel channel) {
        this.blockingStub = IncrStatusGrpc.newBlockingStub(channel);
        this.asyncStub = IncrStatusGrpc.newStub(channel);
        this.logCollectorBlockingStub = LogCollectorGrpc.newBlockingStub(channel);
    }

    public PingResult ping() {
        com.qlangtech.tis.grpc.PingResult ping = this.blockingStub.ping(Empty.newBuilder().build());
        PingResult result = new PingResult();
        result.setValue(ping.getValue());
        return result;
    }

    public MasterJob reportStatus(com.qlangtech.tis.realtime.yarn.rpc.UpdateCounterMap upateCounter) {
        UpdateCounterMap.Builder builder = UpdateCounterMap.newBuilder();
        upateCounter.getData().entrySet().forEach(e -> {
            TableSingleDataIndexStatus.Builder sbuilder = TableSingleDataIndexStatus.newBuilder();
            com.qlangtech.tis.realtime.transfer.TableSingleDataIndexStatus value = (com.qlangtech.tis.realtime.transfer.TableSingleDataIndexStatus)e.getValue();
            value.getTableConsumeData().entrySet().forEach(ce -> sbuilder.putTableConsumeData((String)ce.getKey(), (Long)ce.getValue()));
            sbuilder.setBufferQueueRemainingCapacity(value.getBufferQueueRemainingCapacity());
            sbuilder.setBufferQueueUsedSize(value.getBufferQueueUsedSize());
            sbuilder.setConsumeErrorCount(value.getConsumeErrorCount());
            sbuilder.setIgnoreRowsCount(value.getIgnoreRowsCount());
            sbuilder.setTis30SAvgRT(value.getIncrRateLimitConfig().serialize());
            sbuilder.setUuid(value.getUUID());
            sbuilder.setIncrProcessPaused(value.isIncrProcessPaused());
            TableSingleDataIndexStatus s = sbuilder.build();
            builder.putData(((PipelineFlinkTaskId)e.getKey()).getKey(), s);
        });
        builder.setFrom(upateCounter.getFrom());
        builder.setGcCounter(upateCounter.getGcCounter());
        builder.setUpdateTime(upateCounter.getUpdateTime());
        UpdateCounterMap updateCounterMap = builder.build();
        com.qlangtech.tis.grpc.MasterJob masterJob = this.blockingStub.reportStatus(updateCounterMap);
        if (masterJob.getJobType() == MasterJob.JobType.None) {
            return null;
        }
        MasterJob job = new MasterJob(JobType.parseJobType((int)masterJob.getJobTypeValue()), masterJob.getIndexName(), masterJob.getUuid());
        job.setStop(masterJob.getStop());
        job.setCreateTime(masterJob.getCreateTime());
        return job;
    }

    public void nodeLaunchReport(LaunchReportInfo launchReportInfo) {
        LaunchReportInfo.Builder builder = com.qlangtech.tis.grpc.LaunchReportInfo.newBuilder();
        launchReportInfo.getCollectionFocusTopicInfo().entrySet().forEach(e -> {
            TopicInfo.Builder topicinfoBuilder = com.qlangtech.tis.grpc.TopicInfo.newBuilder();
            TopicInfo tinfo = (TopicInfo)e.getValue();
            tinfo.getTopicWithTags().entrySet().forEach(i -> {
                LaunchReportInfoEntry.Builder ebuilder = LaunchReportInfoEntry.newBuilder();
                ebuilder.setTopicName((String)i.getKey());
                ebuilder.addAllTagName((Iterable)i.getValue());
                topicinfoBuilder.addTopicWithTags(ebuilder.build());
            });
            builder.putCollectionFocusTopicInfo((String)e.getKey(), topicinfoBuilder.build());
        });
        this.blockingStub.nodeLaunchReport(builder.build());
    }

    public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
        this.blockingStub.reportDumpTableStatus(IncrStatusClient.convert(tableDumpStatus));
    }

    public static TableDumpStatus convert(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
        TableDumpStatus.Builder builder = TableDumpStatus.newBuilder();
        builder.setAllRows(tableDumpStatus.getAllRows());
        builder.setComplete(tableDumpStatus.isComplete());
        builder.setFaild(tableDumpStatus.isFaild());
        builder.setReadRows(tableDumpStatus.getReadRows());
        builder.setTableName(tableDumpStatus.getName());
        builder.setTaskid(tableDumpStatus.getTaskid());
        builder.setWaiting(tableDumpStatus.isWaiting());
        return builder.build();
    }

    public void initSynJob(PhaseStatusCollection buildStatus) {
        this.logCollectorBlockingStub.initTask(LogCollectorClient.convertPP(buildStatus));
    }

    public PhaseStatusCollection loadPhaseStatusFromLatest(Integer taskId) {
        Objects.requireNonNull(taskId, "taskId can not be null");
        PPhaseStatusCollection statusCollection = this.logCollectorBlockingStub.loadPhaseStatus(PBuildPhaseStatusParam.newBuilder().setTaskid(taskId.intValue()).build());
        if (statusCollection == null || statusCollection.getTaskId() < 1) {
            return null;
        }
        return LogCollectorClient.convert(statusCollection, ExecutePhaseRange.fullRange());
    }

    public void reportBuildIndexStatus(BuildSharedPhaseStatus buildStatus) {
        BuildSharedPhaseStatus.Builder builder = com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus.newBuilder();
        builder.setAllBuildSize(buildStatus.getAllBuildSize());
        builder.setBuildReaded(buildStatus.getBuildReaded());
        builder.setComplete(buildStatus.isComplete());
        builder.setFaild(buildStatus.isFaild());
        builder.setSharedName(buildStatus.getSharedName());
        builder.setTaskid(buildStatus.getTaskid());
        builder.setWaiting(buildStatus.isWaiting());
        this.blockingStub.reportBuildIndexStatus(builder.build());
    }

    public void reportJoinStatus(Integer taskId, JoinPhaseStatus.JoinTaskStatus joinTaskStatus) {
        Objects.requireNonNull(taskId, "taskId can not be null");
        JoinTaskStatus.Builder joinStatBuilder = JoinTaskStatus.newBuilder();
        joinStatBuilder.setTaskid(taskId);
        joinStatBuilder.setJoinTaskName(joinTaskStatus.getName());
        joinStatBuilder.setWaiting(joinTaskStatus.isWaiting());
        joinStatBuilder.setFaild(joinTaskStatus.isFaild());
        joinStatBuilder.setComplete(joinTaskStatus.isComplete());
        JobLog.Builder logBuilder = null;
        JobLog log = null;
        for (Map.Entry entry : joinTaskStatus.jobsStatus.entrySet()) {
            log = (JobLog)entry.getValue();
            logBuilder = com.qlangtech.tis.rpc.grpc.log.common.JobLog.newBuilder();
            logBuilder.setMapper(log.getMapper());
            logBuilder.setReducer(log.getReducer());
            logBuilder.setWaiting(log.isWaiting());
            joinStatBuilder.putJobStatus((Integer)entry.getKey(), logBuilder.build());
        }
        this.blockingStub.reportJoinStatus(joinStatBuilder.build());
    }

    public static void main(String[] args) throws InterruptedException {
        String target = "localhost:8980";
        if (args.length > 0) {
            if ("--help".equals(args[0])) {
                System.err.println("Usage: [target]");
                System.err.println("");
                System.err.println("  target  The server to connect to. Defaults to " + target);
                System.exit(1);
            }
            target = args[0];
        }
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        try {
            IncrStatusClient client = new IncrStatusClient((Channel)channel);
            while (true) {
                client.ping();
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
            throw throwable;
        }
    }
}

