/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.grpc.log;

import ch.qos.logback.classic.Level;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.GeneratedMessageV3;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.IndexBackFlowPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.ILogReporter;
import com.qlangtech.tis.rpc.grpc.log.common.BuildSharedPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.common.JobLog;
import com.qlangtech.tis.rpc.grpc.log.common.JoinTaskStatus;
import com.qlangtech.tis.rpc.grpc.log.common.NodeBackflowStatus;
import com.qlangtech.tis.rpc.grpc.log.common.TableDumpStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.LogCollectorGrpc;
import com.qlangtech.tis.rpc.grpc.log.stream.PBuildPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.PBuildPhaseStatusParam;
import com.qlangtech.tis.rpc.grpc.log.stream.PDumpPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.PExecuteState;
import com.qlangtech.tis.rpc.grpc.log.stream.PIndexBackFlowPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.PJoinPhaseStatus;
import com.qlangtech.tis.rpc.grpc.log.stream.PMonotorTarget;
import com.qlangtech.tis.rpc.grpc.log.stream.PPhaseStatusCollection;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.trigger.jst.MonotorTarget;
import com.qlangtech.tis.trigger.jst.RegisterMonotorTarget;
import com.qlangtech.tis.trigger.socket.ExecuteState;
import com.qlangtech.tis.trigger.socket.InfoType;
import com.qlangtech.tis.trigger.socket.LogType;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollectorClient
implements ILogReporter {
    private static final Logger logger = LoggerFactory.getLogger(LogCollectorClient.class);
    private final LogCollectorGrpc.LogCollectorStub stub;
    private final LogCollectorGrpc.LogCollectorBlockingStub blockStub;
    private static final Map<Integer, PExecuteState.LogType> logTypeMap;

    public LogCollectorClient(ManagedChannel channel) {
        this.blockStub = LogCollectorGrpc.newBlockingStub((Channel)channel);
        this.stub = LogCollectorGrpc.newStub((Channel)channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String target = "10.1.24.59:46478";
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"10.1.24.59:46478").usePlaintext().build();
        LogCollectorClient logCollectorClient = new LogCollectorClient(channel);
        int taskid = 323;
        System.out.println("start exec buildPhraseStatus");
        logCollectorClient.buildPhraseStatus(taskid);
        String string = "10.1.24.59:46478";
        synchronized ("10.1.24.59:46478") {
            "10.1.24.59:46478".wait();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static PPhaseStatusCollection convertPP(PhaseStatusCollection phaseStatusSet) {
        GeneratedMessageV3.Builder builder;
        PPhaseStatusCollection.Builder scBuilder = PPhaseStatusCollection.newBuilder();
        scBuilder.setTaskId(phaseStatusSet.getTaskid());
        DumpPhaseStatus dumpPhase = phaseStatusSet.getDumpPhase();
        JoinPhaseStatus joinPhase = phaseStatusSet.getJoinPhase();
        BuildPhaseStatus buildPhase = phaseStatusSet.getBuildPhase();
        IndexBackFlowPhaseStatus indexBackFlowPhase = phaseStatusSet.getIndexBackFlowPhaseStatus();
        if (dumpPhase != null) {
            builder = PDumpPhaseStatus.newBuilder();
            TableDumpStatus.Builder tabDump = null;
            DumpPhaseStatus.TableDumpStatus s = null;
            for (Map.Entry entry : dumpPhase.tablesDump.entrySet()) {
                s = (DumpPhaseStatus.TableDumpStatus)entry.getValue();
                tabDump = TableDumpStatus.newBuilder();
                tabDump.setAllRows(s.getAllRows());
                tabDump.setTableName(s.getName());
                tabDump.setTaskid(s.getTaskid());
                tabDump.setReadRows(s.getReadRows());
                tabDump.setFaild(s.isFaild());
                tabDump.setComplete(s.isComplete());
                tabDump.setWaiting(s.isWaiting());
                builder.putTablesDump((String)entry.getKey(), tabDump.build());
            }
            scBuilder.setDumpPhase((PDumpPhaseStatus.Builder)builder);
        }
        if (joinPhase != null) {
            builder = PJoinPhaseStatus.newBuilder();
            JoinTaskStatus.Builder pbuilder = null;
            JoinPhaseStatus.JoinTaskStatus j = null;
            JobLog.Builder jlog = null;
            com.qlangtech.tis.fullbuild.phasestatus.JobLog jl = null;
            for (Map.Entry entry : joinPhase.taskStatus.entrySet()) {
                pbuilder = JoinTaskStatus.newBuilder();
                j = (JoinPhaseStatus.JoinTaskStatus)entry.getValue();
                pbuilder.setJoinTaskName(j.getName());
                pbuilder.setFaild(j.isFaild());
                pbuilder.setComplete(j.isComplete());
                pbuilder.setWaiting(j.isWaiting());
                for (Map.Entry e : j.jobsStatus.entrySet()) {
                    jl = (com.qlangtech.tis.fullbuild.phasestatus.JobLog)e.getValue();
                    jlog = JobLog.newBuilder();
                    jlog.setMapper(jl.getMapper());
                    jlog.setReducer(jl.getReducer());
                    jlog.setWaiting(jl.isWaiting());
                    pbuilder.putJobStatus((Integer)e.getKey(), jlog.build());
                }
                builder.putTaskStatus((String)entry.getKey(), pbuilder.build());
            }
            scBuilder.setJoinPhase((PJoinPhaseStatus.Builder)builder);
        }
        if (buildPhase != null) {
            builder = PBuildPhaseStatus.newBuilder();
            buildPhase.nodeBuildStatus.entrySet().stream().forEach(arg_0 -> LogCollectorClient.lambda$convertPP$0((PBuildPhaseStatus.Builder)builder, arg_0));
            scBuilder.setBuildPhase((PBuildPhaseStatus.Builder)builder);
        }
        if (indexBackFlowPhase != null) {
            builder = PIndexBackFlowPhaseStatus.newBuilder();
            indexBackFlowPhase.nodesStatus.entrySet().stream().forEach(arg_0 -> LogCollectorClient.lambda$convertPP$1((PIndexBackFlowPhaseStatus.Builder)builder, arg_0));
            scBuilder.setIndexBackFlowPhaseStatus((PIndexBackFlowPhaseStatus.Builder)builder);
        }
        return scBuilder.build();
    }

    @Override
    public StreamObserver<PMonotorTarget> registerMonitorEvent(final ILogListener logListener) {
        ClientResponseObserver<PMonotorTarget, PExecuteState> clientResponseObserver = new ClientResponseObserver<PMonotorTarget, PExecuteState>(){
            ClientCallStreamObserver<PMonotorTarget> requestStream;

            public void beforeStart(ClientCallStreamObserver<PMonotorTarget> requestStream) {
                this.requestStream = requestStream;
                requestStream.setOnReadyHandler(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }

            public void onNext(PExecuteState value) {
                if (logListener.isClosed()) {
                    this.requestStream.onCompleted();
                    return;
                }
                try {
                    logListener.read((Object)value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void onError(Throwable t) {
                t.printStackTrace();
            }

            public void onCompleted() {
                logger.info("All Done");
            }
        };
        StreamObserver<PMonotorTarget> pMonotorTargetStreamObserver = this.stub.registerMonitorEvent((StreamObserver<PExecuteState>)clientResponseObserver);
        return pMonotorTargetStreamObserver;
    }

    public static MonotorTarget convert(PMonotorTarget request) {
        RegisterMonotorTarget monotorTarget = MonotorTarget.createRegister((DataXName)DataXName.createDataXPipeline((String)request.getCollection()), (LogType)LogCollectorClient.convert(request.getLogtype()));
        if (request.getTaskid() > 0) {
            monotorTarget.setTaskid(Integer.valueOf(request.getTaskid()));
        }
        return monotorTarget;
    }

    private ExecuteState convert(PExecuteState state) throws Exception {
        ExecuteState s = ExecuteState.create((LogType)LogCollectorClient.convert(state.getLogType()), (Object)state.getMsg());
        s.setServiceName(state.getServiceName());
        s.setComponent(state.getComponent());
        s.setExecState(state.getExecState());
        s.setJobId(Long.valueOf(state.getJobId()));
        s.setTaskId(Long.valueOf(state.getTaskId()));
        s.setTime(state.getTime());
        return s;
    }

    public static PExecuteState.InfoType convert(Level level) {
        if (level.toInt() == Level.DEBUG.toInt()) {
            return PExecuteState.InfoType.INFO;
        }
        if (level.toInt() == Level.INFO.toInt()) {
            return PExecuteState.InfoType.INFO;
        }
        if (level.toInt() == Level.WARN.toInt()) {
            return PExecuteState.InfoType.WARN;
        }
        if (level.toInt() == Level.ERROR.toInt()) {
            return PExecuteState.InfoType.ERROR;
        }
        throw new IllegalArgumentException("level:" + level + " is illegal");
    }

    private InfoType convert(PExecuteState.InfoType itype) {
        switch (itype) {
            case INFO: {
                return InfoType.INFO;
            }
            case WARN: {
                return InfoType.WARN;
            }
            case ERROR: {
                return InfoType.ERROR;
            }
            case FATAL: {
                return InfoType.FATAL;
            }
        }
        throw new IllegalStateException("info type is illegal:" + itype);
    }

    public static LogType convert(PExecuteState.LogType logtype) {
        switch (logtype) {
            case MQ_TAGS_STATUS: {
                throw new UnsupportedOperationException("logtype :" + logtype);
            }
            case INCR_SEND: {
                return LogType.INCR_SEND;
            }
            case INCR_DEPLOY_STATUS_CHANGE: {
                return LogType.INCR_DEPLOY_STATUS_CHANGE;
            }
            case FULL: {
                return LogType.FULL;
            }
            case INCR: {
                return LogType.INCR;
            }
        }
        throw new IllegalStateException("in valid logtype:" + logtype);
    }

    public static PExecuteState.LogType convert(int logtypeKind) {
        PExecuteState.LogType type = logTypeMap.get(logtypeKind);
        if (type == null) {
            throw new IllegalStateException("in valid logtype:" + logtypeKind);
        }
        return type;
    }

    @Override
    public Iterator<PPhaseStatusCollection> buildPhraseStatus(Integer taskid) {
        PBuildPhaseStatusParam statusParam = PBuildPhaseStatusParam.newBuilder().setTaskid(taskid.intValue()).build();
        return this.blockStub.buildPhraseStatus(statusParam);
    }

    public static PhaseStatusCollection convert(PPhaseStatusCollection stat, ExecutePhaseRange executePhaseRange) {
        PDumpPhaseStatus dumpPhase = Objects.requireNonNull(stat, "param stat can not be null").getDumpPhase();
        PJoinPhaseStatus joinPhase = stat.getJoinPhase();
        PBuildPhaseStatus buildPhase = stat.getBuildPhase();
        PIndexBackFlowPhaseStatus backflow = stat.getIndexBackFlowPhaseStatus();
        PhaseStatusCollection result = new PhaseStatusCollection(Integer.valueOf(stat.getTaskId()), executePhaseRange);
        if (executePhaseRange.contains(FullbuildPhase.FullDump) && dumpPhase != null) {
            DumpPhaseStatus dump = result.getDumpPhase();
            dumpPhase.getTablesDumpMap().forEach((k, v) -> {
                DumpPhaseStatus.TableDumpStatus s = new DumpPhaseStatus.TableDumpStatus(v.getTableName(), v.getTaskid());
                s.setAllRows(v.getAllRows());
                s.setReadRows(v.getReadRows());
                s.setComplete(v.getComplete());
                s.setFaild(v.getFaild());
                s.setWaiting(v.getWaiting());
                dump.tablesDump.put(k, s);
            });
        }
        if (executePhaseRange.contains(FullbuildPhase.JOIN) && joinPhase != null) {
            JoinPhaseStatus join = result.getJoinPhase();
            Map sm = join.taskStatus;
            joinPhase.getTaskStatusMap().forEach((k, v) -> {
                JoinPhaseStatus.JoinTaskStatus s = LogCollectorClient.convert(v);
                sm.put(k, s);
            });
        }
        if (executePhaseRange.contains(FullbuildPhase.BUILD) && buildPhase != null) {
            BuildPhaseStatus build = result.getBuildPhase();
            buildPhase.getNodeBuildStatusMap().forEach((k, v) -> {
                com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus s = new com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus();
                s.setAllBuildSize(v.getAllBuildSize());
                s.setBuildReaded(v.getBuildReaded());
                s.setTaskid(Integer.valueOf(v.getTaskid()));
                s.setSharedName(v.getSharedName());
                s.setComplete(v.getComplete());
                s.setFaild(v.getFaild());
                s.setWaiting(v.getWaiting());
                build.nodeBuildStatus.put(k, s);
            });
        }
        if (executePhaseRange.contains(FullbuildPhase.IndexBackFlow) && backflow != null) {
            IndexBackFlowPhaseStatus bf = result.getIndexBackFlowPhaseStatus();
            backflow.getNodesStatusMap().forEach((k, v) -> {
                IndexBackFlowPhaseStatus.NodeBackflowStatus s = new IndexBackFlowPhaseStatus.NodeBackflowStatus(v.getNodeName());
                s.setAllSize((int)v.getAllSize());
                s.setReaded((int)v.getReaded());
                s.setComplete(v.getComplete());
                s.setFaild(v.getFaild());
                s.setWaiting(v.getWaiting());
                bf.nodesStatus.put(k, s);
            });
        }
        return result;
    }

    public static JoinPhaseStatus.JoinTaskStatus convert(JoinTaskStatus v) {
        JoinPhaseStatus.JoinTaskStatus s = new JoinPhaseStatus.JoinTaskStatus(v.getJoinTaskName());
        s.setComplete(v.getComplete());
        s.setFaild(v.getFaild());
        s.setWaiting(v.getWaiting());
        v.getJobStatusMap().forEach((jk, jv) -> {
            com.qlangtech.tis.fullbuild.phasestatus.JobLog jl = new com.qlangtech.tis.fullbuild.phasestatus.JobLog();
            jl.setMapper(jv.getMapper());
            jl.setReducer(jv.getReducer());
            jl.setWaiting(jv.getWaiting());
            s.jobsStatus.put(jk, jl);
        });
        return s;
    }

    private static /* synthetic */ void lambda$convertPP$1(PIndexBackFlowPhaseStatus.Builder builder, Map.Entry e) {
        IndexBackFlowPhaseStatus.NodeBackflowStatus ib = (IndexBackFlowPhaseStatus.NodeBackflowStatus)e.getValue();
        NodeBackflowStatus.Builder ibBuilder = NodeBackflowStatus.newBuilder();
        ibBuilder.setNodeName(ib.getName());
        ibBuilder.setAllSize(ib.getAllSize());
        ibBuilder.setReaded(ib.getReaded());
        ibBuilder.setFaild(ib.isFaild());
        ibBuilder.setComplete(ib.isComplete());
        ibBuilder.setWaiting(ib.isWaiting());
        builder.putNodesStatus((String)e.getKey(), ibBuilder.build());
    }

    private static /* synthetic */ void lambda$convertPP$0(PBuildPhaseStatus.Builder builder, Map.Entry e) {
        com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus bf = null;
        BuildSharedPhaseStatus.Builder bfBuilder = BuildSharedPhaseStatus.newBuilder();
        bf = (com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus)e.getValue();
        bfBuilder.setAllBuildSize(bf.getAllBuildSize());
        bfBuilder.setBuildReaded(bf.getBuildReaded());
        bfBuilder.setTaskid(bf.getTaskid());
        bfBuilder.setSharedName(bf.getSharedName());
        bfBuilder.setFaild(bf.isFaild());
        bfBuilder.setComplete(bf.isComplete());
        bfBuilder.setWaiting(bf.isWaiting());
        builder.putNodeBuildStatus((String)e.getKey(), bfBuilder.build());
    }

    static {
        ImmutableMap.Builder logTypeMapBuilder = ImmutableMap.builder();
        logTypeMapBuilder.put((Object)LogType.INCR_SEND.typeKind, (Object)PExecuteState.LogType.INCR_SEND);
        logTypeMapBuilder.put((Object)LogType.INCR_DEPLOY_STATUS_CHANGE.typeKind, (Object)PExecuteState.LogType.INCR_DEPLOY_STATUS_CHANGE);
        logTypeMapBuilder.put((Object)LogType.FULL.typeKind, (Object)PExecuteState.LogType.FULL);
        logTypeMapBuilder.put((Object)LogType.INCR.typeKind, (Object)PExecuteState.LogType.INCR);
        logTypeMap = logTypeMapBuilder.build();
    }

    public static interface IPhaseStatusCollectionListener {
        public boolean isReady();

        public boolean process(PPhaseStatusCollection var1) throws Exception;
    }
}

