/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.rpc.grpc.log;

import com.qlangtech.tis.rpc.grpc.log.ILoggerAppenderClient;
import com.qlangtech.tis.rpc.grpc.log.appender.LogAppenderGrpc;
import com.qlangtech.tis.rpc.grpc.log.appender.LoggingEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Map;
import java.util.Objects;

public class DefaultLoggerAppenderClient
implements ILoggerAppenderClient {
    final LogAppenderGrpc.LogAppenderBlockingStub logAppenderBlockingStub;

    public DefaultLoggerAppenderClient(ManagedChannel channel) {
        this.logAppenderBlockingStub = LogAppenderGrpc.newBlockingStub((Channel)channel);
    }

    public void append(Map<String, String> headers, ILoggerAppenderClient.LogLevel level, String message) {
        LoggingEvent.Builder evtBuilder = LoggingEvent.newBuilder();
        switch (level) {
            case INFO: {
                evtBuilder.setLevel(LoggingEvent.Level.INFO);
                break;
            }
            case ERROR: {
                evtBuilder.setLevel(LoggingEvent.Level.ERROR);
                break;
            }
            case WARNING: {
                evtBuilder.setLevel(LoggingEvent.Level.WARNING);
                break;
            }
            default: {
                throw new IllegalStateException("illegal level type:" + level);
            }
        }
        evtBuilder.setBody(message);
        evtBuilder.putAllHeaders(headers);
        this.logAppenderBlockingStub.append(Objects.requireNonNull(evtBuilder.build(), "param event can not be null"));
    }
}

