/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.canal;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.StringUtils;

public class CanalJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"INSERT");
    private static final StringData OP_DELETE = StringData.fromString((String)"DELETE");
    private transient GenericRowData reuse;
    private final JsonRowDataSerializationSchema jsonSerializer;
    private final String targetTableName;

    public CanalJsonSerializationSchema(String targetTableName, RowType rowType, TimestampFormat timestampFormat, JsonFormatOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber, boolean ignoreNullFields) {
        if (StringUtils.isNullOrWhitespaceOnly((String)targetTableName)) {
            throw new IllegalArgumentException("param targetTableName can not be null");
        }
        this.targetTableName = targetTableName;
        this.jsonSerializer = new JsonRowDataSerializationSchema(CanalJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber, ignoreNullFields);
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.jsonSerializer.open(context);
        this.reuse = new GenericRowData(4);
    }

    public byte[] serialize(RowData row) {
        try {
            StringData opType = this.rowKind2String(row.getRowKind());
            GenericArrayData arrayData = new GenericArrayData((Object[])new RowData[]{row});
            this.reuse.setField(0, (Object)arrayData);
            this.reuse.setField(1, (Object)opType);
            this.reuse.setField(2, (Object)StringData.fromString((String)this.targetTableName));
            this.reuse.setField(3, (Object)System.currentTimeMillis());
            return this.jsonSerializer.serialize((RowData)this.reuse);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t);
        }
    }

    private StringData rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + rowKind + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonSerializationSchema that = (CanalJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)databaseSchema)), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"table", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.BIGINT())}).getLogicalType();
    }
}

