/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector.heap;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.columnar.ColumnarArrayData;
import org.apache.flink.table.data.columnar.vector.ArrayColumnVector;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;

@Internal
public class HeapArrayVector
extends AbstractHeapVector
implements WritableColumnVector,
ArrayColumnVector {
    private long[] offsets;
    private long[] lengths;
    private int size;
    private ColumnVector child;

    public HeapArrayVector(int len) {
        super(len);
        this.offsets = new long[len];
        this.lengths = new long[len];
    }

    public HeapArrayVector(int len, ColumnVector vector) {
        super(len);
        this.offsets = new long[len];
        this.lengths = new long[len];
        this.child = vector;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public ColumnVector getChild() {
        return this.child;
    }

    public void setChild(ColumnVector child) {
        this.child = child;
    }

    @Override
    public ArrayData getArray(int i) {
        long offset = this.offsets[i];
        long length = this.lengths[i];
        return new ColumnarArrayData(this.child, (int)offset, (int)length);
    }
}

