/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.common;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowProcessor;
import org.apache.flink.util.Preconditions;

@Internal
public final class WindowAggOperator<K, W>
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
Triggerable<K, W>,
KeyContext {
    private static final long serialVersionUID = 1L;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private static final String LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "lateRecordsDroppedRate";
    private static final String WATERMARK_LATENCY_METRIC_NAME = "watermarkLatency";
    private final WindowProcessor<W> windowProcessor;
    private final boolean isEventTime;
    private transient TimestampedCollector<RowData> collector;
    private transient InternalTimerService<W> internalTimerService;
    private transient long lastTriggeredProcessingTime;
    private transient ListState<Long> watermarkState;
    private transient Counter numLateRecordsDropped;
    private transient Meter lateRecordsDroppedRate;
    private transient Gauge<Long> watermarkLatency;

    public WindowAggOperator(WindowProcessor<W> windowProcessor, boolean isEventTime) {
        this.windowProcessor = windowProcessor;
        this.isEventTime = isEventTime;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.lastTriggeredProcessingTime = Long.MIN_VALUE;
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        this.internalTimerService = this.getInternalTimerService("window-timers", this.windowProcessor.createWindowSerializer(), this);
        this.windowProcessor.open(new WindowProcessorContext<W>(this.getContainingTask(), this.getContainingTask().getEnvironment().getMemoryManager(), this.computeMemorySize(), this.internalTimerService, (KeyedStateBackend<RowData>)this.getKeyedStateBackend(), (Output<RowData>)this.collector, (RuntimeContext)this.getRuntimeContext()));
        this.windowProcessor.initializeWatermark(this.currentWatermark);
        this.numLateRecordsDropped = this.metrics.counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.lateRecordsDroppedRate = this.metrics.meter(LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(this.numLateRecordsDropped));
        this.watermarkLatency = this.metrics.gauge(WATERMARK_LATENCY_METRIC_NAME, () -> {
            long watermark = this.internalTimerService.currentWatermark();
            if (watermark < 0L) {
                return 0L;
            }
            return this.internalTimerService.currentProcessingTime() - watermark;
        });
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        Iterable watermarks;
        super.initializeState(context);
        ListStateDescriptor watermarkStateDesc = new ListStateDescriptor("watermark", (TypeSerializer)LongSerializer.INSTANCE);
        this.watermarkState = context.getOperatorStateStore().getUnionListState(watermarkStateDesc);
        if (context.isRestored() && (watermarks = (Iterable)this.watermarkState.get()) != null) {
            long minWatermark = Long.MAX_VALUE;
            for (Long watermark : watermarks) {
                minWatermark = Math.min(watermark, minWatermark);
            }
            if (minWatermark != Long.MAX_VALUE) {
                this.currentWatermark = minWatermark;
            }
        }
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.watermarkState.update(Collections.singletonList(this.currentWatermark));
    }

    public void close() throws Exception {
        super.close();
        this.collector = null;
        this.windowProcessor.close();
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData inputRow = (RowData)element.getValue();
        RowData currentKey = (RowData)this.getCurrentKey();
        boolean isElementDropped = this.windowProcessor.processElement(currentKey, inputRow);
        if (isElementDropped) {
            this.lateRecordsDroppedRate.markEvent();
        }
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() > this.currentWatermark) {
            if (this.isEventTime) {
                this.windowProcessor.advanceProgress(mark.getTimestamp());
            }
            super.processWatermark(mark);
        } else {
            super.processWatermark(new Watermark(this.currentWatermark));
        }
    }

    public void onEventTime(InternalTimer<K, W> timer) throws Exception {
        this.onTimer(timer);
    }

    public void onProcessingTime(InternalTimer<K, W> timer) throws Exception {
        if (timer.getTimestamp() > this.lastTriggeredProcessingTime) {
            this.lastTriggeredProcessingTime = timer.getTimestamp();
            this.windowProcessor.advanceProgress(timer.getTimestamp());
        }
        this.onTimer(timer);
    }

    private void onTimer(InternalTimer<K, W> timer) throws Exception {
        this.setCurrentKey(timer.getKey());
        Object window = timer.getNamespace();
        this.windowProcessor.fireWindow(timer.getTimestamp(), window);
        this.windowProcessor.clearWindow(timer.getTimestamp(), window);
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.windowProcessor.prepareCheckpoint();
    }

    @VisibleForTesting
    public Counter getNumLateRecordsDropped() {
        return this.numLateRecordsDropped;
    }

    @VisibleForTesting
    public Gauge<Long> getWatermarkLatency() {
        return this.watermarkLatency;
    }

    private static final class WindowProcessorContext<W>
    implements WindowProcessor.Context<W> {
        private final Object operatorOwner;
        private final MemoryManager memoryManager;
        private final long memorySize;
        private final InternalTimerService<W> timerService;
        private final KeyedStateBackend<RowData> keyedStateBackend;
        private final Output<RowData> collector;
        private final RuntimeContext runtimeContext;

        private WindowProcessorContext(Object operatorOwner, MemoryManager memoryManager, long memorySize, InternalTimerService<W> timerService, KeyedStateBackend<RowData> keyedStateBackend, Output<RowData> collector, RuntimeContext runtimeContext) {
            this.operatorOwner = operatorOwner;
            this.memoryManager = memoryManager;
            this.memorySize = memorySize;
            this.timerService = timerService;
            this.keyedStateBackend = (KeyedStateBackend)Preconditions.checkNotNull(keyedStateBackend);
            this.collector = (Output)Preconditions.checkNotNull(collector);
            this.runtimeContext = (RuntimeContext)Preconditions.checkNotNull((Object)runtimeContext);
        }

        @Override
        public Object getOperatorOwner() {
            return this.operatorOwner;
        }

        @Override
        public MemoryManager getMemoryManager() {
            return this.memoryManager;
        }

        @Override
        public long getMemorySize() {
            return this.memorySize;
        }

        @Override
        public KeyedStateBackend<RowData> getKeyedStateBackend() {
            return this.keyedStateBackend;
        }

        @Override
        public InternalTimerService<W> getTimerService() {
            return this.timerService;
        }

        @Override
        public void output(RowData result) {
            this.collector.collect((Object)result);
        }

        @Override
        public RuntimeContext getRuntimeContext() {
            return this.runtimeContext;
        }
    }
}

