/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.RemovalCause;
import org.apache.flink.shaded.guava31.com.google.common.cache.RemovalListener;
import org.apache.flink.shaded.guava31.com.google.common.cache.RemovalNotification;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastTop1Function
extends AbstractTopNFunction
implements CheckpointedFunction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FastTop1Function.class);
    private final TypeSerializer<RowData> inputRowSer;
    private final long cacheSize;
    private transient ValueState<RowData> dataState;
    private transient Cache<RowData, RowData> kvCache;

    public FastTop1Function(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator generatedSortKeyComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, long cacheSize) {
        super(ttlConfig, inputRowType, generatedSortKeyComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.inputRowSer = inputRowType.createSerializer((SerializerConfig)new SerializerConfigImpl());
        this.cacheSize = cacheSize;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        int lruCacheSize = Math.max(1, (int)(this.cacheSize / this.getDefaultTopNSize()));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.ttlConfig.isEnabled()) {
            cacheBuilder.expireAfterWrite(this.ttlConfig.getTtl().toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        this.kvCache = cacheBuilder.maximumSize((long)lruCacheSize).removalListener((RemovalListener)new CacheRemovalListener()).build();
        LOG.info("Top-1 operator is using LRU caches key-size: {}", (Object)lruCacheSize);
        ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor("Top1-Rank-State", (TypeInformation)this.inputRowType);
        if (this.ttlConfig.isEnabled()) {
            valueStateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.dataState = this.getRuntimeContext().getState(valueStateDescriptor);
        this.registerMetric(this.kvCache.size() * this.getDefaultTopNSize());
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowData oldSortKey;
        ++this.requestCount;
        RowData currentKey = (RowData)this.keyContext.getCurrentKey();
        RowData prevRow = (RowData)this.kvCache.getIfPresent((Object)currentKey);
        if (prevRow == null) {
            prevRow = (RowData)this.dataState.value();
        } else {
            ++this.hitCount;
        }
        if (prevRow == null) {
            this.kvCache.put((Object)currentKey, (Object)((RowData)this.inputRowSer.copy((Object)input)));
            if (this.outputRankNumber) {
                this.collectInsert(out, input, 1L);
            } else {
                this.collectInsert(out, input);
            }
            return;
        }
        RowData curSortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        int compare = this.sortKeyComparator.compare(curSortKey, oldSortKey = (RowData)this.sortKeySelector.getKey((Object)prevRow));
        if (compare < 0) {
            this.kvCache.put((Object)currentKey, (Object)((RowData)this.inputRowSer.copy((Object)input)));
            if (this.outputRankNumber) {
                this.collectUpdateBefore(out, prevRow, 1L);
                this.collectUpdateAfter(out, input, 1L);
            } else {
                this.collectUpdateBefore(out, prevRow);
                this.collectUpdateAfter(out, input);
            }
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        for (Map.Entry entry : this.kvCache.asMap().entrySet()) {
            this.keyContext.setCurrentKey(entry.getKey());
            this.dataState.update((Object)((RowData)entry.getValue()));
        }
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
    }

    private class CacheRemovalListener
    implements RemovalListener<RowData, RowData> {
        private CacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<RowData, RowData> notification) {
            if (notification.getCause() != RemovalCause.SIZE || notification.getValue() == null) {
                return;
            }
            RowData previousKey = (RowData)FastTop1Function.this.keyContext.getCurrentKey();
            RowData partitionKey = (RowData)notification.getKey();
            FastTop1Function.this.keyContext.setCurrentKey((Object)partitionKey);
            try {
                FastTop1Function.this.dataState.update((Object)((RowData)notification.getValue()));
            }
            catch (Throwable e) {
                LOG.error("Fail to synchronize state!", e);
                throw new RuntimeException(e);
            }
            finally {
                FastTop1Function.this.keyContext.setCurrentKey((Object)previousKey);
            }
        }
    }
}

