/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.connectors.CollectDynamicSink;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.typeutils.RowTypeUtils;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.sink.SinkUpsertMaterializer;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@ExecNodeMetadata(name="stream-exec-sink", version=1, consumedOptions={"table.exec.sink.not-null-enforcer", "table.exec.sink.type-length-enforcer", "table.exec.sink.upsert-materialize", "table.exec.sink.keyed-shuffle", "table.exec.sink.rowtime-inserter"}, producedTransformations={"constraint-validator", "partitioner", "upsert-materialize", "timestamp-inserter", "sink"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecSink
extends CommonExecSink
implements StreamExecNode<Object> {
    public static final String FIELD_NAME_INPUT_CHANGELOG_MODE = "inputChangelogMode";
    public static final String FIELD_NAME_REQUIRE_UPSERT_MATERIALIZE = "requireUpsertMaterialize";
    public static final String FIELD_NAME_INPUT_UPSERT_KEY = "inputUpsertKey";
    public static final String STATE_NAME = "sinkMaterializeState";
    @JsonProperty(value="inputChangelogMode")
    private final ChangelogMode inputChangelogMode;
    @JsonProperty(value="requireUpsertMaterialize")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean upsertMaterialize;
    @JsonProperty(value="inputUpsertKey")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final int[] inputUpsertKey;
    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;

    public StreamExecSink(ReadableConfig tableConfig, DynamicTableSinkSpec tableSinkSpec, ChangelogMode inputChangelogMode, InputProperty inputProperty, LogicalType outputType, boolean upsertMaterialize, int[] inputUpsertKey, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecSink.class), ExecNodeContext.newPersistedConfig(StreamExecSink.class, tableConfig), tableSinkSpec, inputChangelogMode, upsertMaterialize, upsertMaterialize ? StateMetadata.getOneInputOperatorDefaultMeta(tableConfig, STATE_NAME) : null, inputUpsertKey, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecSink(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="dynamicTableSink") DynamicTableSinkSpec tableSinkSpec, @JsonProperty(value="inputChangelogMode") ChangelogMode inputChangelogMode, @JsonProperty(value="requireUpsertMaterialize") boolean upsertMaterialize, @Nullable @JsonProperty(value="state") List<StateMetadata> stateMetadataList, @JsonProperty(value="inputUpsertKey") int[] inputUpsertKey, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, tableSinkSpec, inputChangelogMode, false, inputProperties, outputType, description);
        this.inputChangelogMode = inputChangelogMode;
        this.upsertMaterialize = upsertMaterialize;
        this.inputUpsertKey = inputUpsertKey;
        this.stateMetadataList = stateMetadataList;
    }

    @Override
    protected Transformation<Object> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int rowtimeFieldIndex;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        DynamicTableSink tableSink = this.tableSinkSpec.getTableSink(planner.getFlinkContext());
        boolean isCollectSink = tableSink instanceof CollectDynamicSink;
        boolean isDisabled = config.get(ExecutionConfigOptions.TABLE_EXEC_SINK_ROWTIME_INSERTER) == ExecutionConfigOptions.RowtimeInserter.DISABLED;
        ArrayList<Integer> rowtimeFieldIndices = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inputRowType.getFieldCount(); ++i2) {
            if (!TypeCheckUtils.isRowTime((LogicalType)inputRowType.getTypeAt(i2))) continue;
            rowtimeFieldIndices.add(i2);
        }
        if (isCollectSink || isDisabled) {
            rowtimeFieldIndex = -1;
        } else {
            if (rowtimeFieldIndices.size() > 1) {
                throw new TableException(String.format("The query contains more than one rowtime attribute column [%s] for writing into table '%s'.\nPlease select the column that should be used as the event-time timestamp for the table sink by casting all other columns to regular TIMESTAMP or TIMESTAMP_LTZ.", rowtimeFieldIndices.stream().map(i -> (String)inputRowType.getFieldNames().get((int)i)).collect(Collectors.joining(", ")), this.tableSinkSpec.getContextResolvedTable().getIdentifier().asSummaryString()));
            }
            rowtimeFieldIndex = rowtimeFieldIndices.size() == 1 ? (Integer)rowtimeFieldIndices.get(0) : -1;
        }
        return this.createSinkTransformation(planner.getExecEnv(), config, planner.getFlinkContext().getClassLoader(), inputTransform, tableSink, rowtimeFieldIndex, this.upsertMaterialize, this.inputUpsertKey);
    }

    @Override
    protected Transformation<RowData> applyUpsertMaterialize(Transformation<RowData> inputTransform, int[] primaryKeys, int sinkParallelism, ExecNodeConfig config, ClassLoader classLoader, RowType physicalRowType, int[] inputUpsertKey) {
        GeneratedRecordEqualiser rowEqualiser = new EqualiserCodeGenerator(physicalRowType, classLoader).generateRecordEqualiser("SinkMaterializeEqualiser");
        GeneratedRecordEqualiser upsertKeyEqualiser = inputUpsertKey == null ? null : new EqualiserCodeGenerator(RowTypeUtils.projectRowType(physicalRowType, inputUpsertKey), classLoader).generateRecordEqualiser("SinkMaterializeUpsertKeyEqualiser");
        long stateRetentionTime = StateMetadata.getStateTtlForOneInputOperator(config, this.stateMetadataList);
        SinkUpsertMaterializer operator = new SinkUpsertMaterializer(StateConfigUtil.createTtlConfig((long)stateRetentionTime), (TypeSerializer)InternalSerializers.create((RowType)physicalRowType), rowEqualiser, upsertKeyEqualiser, inputUpsertKey);
        String[] fieldNames = physicalRowType.getFieldNames().toArray(new String[0]);
        List pkFieldNames = Arrays.stream(primaryKeys).mapToObj(idx -> fieldNames[idx]).collect(Collectors.toList());
        OneInputTransformation materializeTransform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta("upsert-materialize", String.format("SinkMaterializer(pk=[%s])", String.join((CharSequence)", ", pkFieldNames)), "SinkMaterializer", config), operator, inputTransform.getOutputType(), sinkParallelism, this.sinkParallelismConfigured);
        RowDataKeySelector keySelector = KeySelectorUtil.getRowDataSelector(classLoader, primaryKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)physicalRowType));
        materializeTransform.setStateKeySelector((KeySelector)keySelector);
        materializeTransform.setStateKeyType((TypeInformation)keySelector.getProducedType());
        return materializeTransform;
    }
}

