/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MatchSpec {
    public static final String FIELD_NAME_PATTERN = "pattern";
    public static final String FIELD_NAME_PATTERN_DEFINITIONS = "patternDefinitions";
    public static final String FIELD_NAME_MEASURES = "measures";
    public static final String FIELD_NAME_AFTER = "after";
    public static final String FIELD_NAME_SUBSETS = "subsets";
    public static final String FIELD_NAME_ALL_ROWS = "allRows";
    public static final String FIELD_NAME_PARTITION = "partition";
    public static final String FIELD_NAME_SORT_SPEC = "orderBy";
    public static final String FIELD_NAME_INTERVAL = "interval";
    @JsonProperty(value="pattern")
    private final RexNode pattern;
    @JsonProperty(value="patternDefinitions")
    private final Map<String, RexNode> patternDefinitions;
    @JsonProperty(value="measures")
    private final Map<String, RexNode> measures;
    @JsonProperty(value="after")
    private final RexNode after;
    @JsonProperty(value="subsets")
    private final Map<String, SortedSet<String>> subsets;
    @JsonProperty(value="allRows")
    private final boolean allRows;
    @JsonProperty(value="partition")
    private final PartitionSpec partition;
    @JsonProperty(value="orderBy")
    private final SortSpec orderKeys;
    @JsonProperty(value="interval")
    @Nullable
    private final RexNode interval;

    @JsonCreator
    public MatchSpec(@JsonProperty(value="pattern") RexNode pattern, @JsonProperty(value="patternDefinitions") Map<String, RexNode> patternDefinitions, @JsonProperty(value="measures") Map<String, RexNode> measures, @JsonProperty(value="after") RexNode after, @JsonProperty(value="subsets") Map<String, SortedSet<String>> subsets, @JsonProperty(value="allRows") boolean allRows, @JsonProperty(value="partition") PartitionSpec partition, @JsonProperty(value="orderBy") SortSpec orderKeys, @JsonProperty(value="interval") @Nullable RexNode interval) {
        this.pattern = (RexNode)Preconditions.checkNotNull((Object)pattern);
        this.patternDefinitions = (Map)Preconditions.checkNotNull(patternDefinitions);
        this.measures = (Map)Preconditions.checkNotNull(measures);
        this.after = (RexNode)Preconditions.checkNotNull((Object)after);
        this.subsets = (Map)Preconditions.checkNotNull(subsets);
        this.allRows = allRows;
        this.partition = (PartitionSpec)Preconditions.checkNotNull((Object)partition);
        this.orderKeys = (SortSpec)Preconditions.checkNotNull((Object)orderKeys);
        this.interval = interval;
    }

    @JsonIgnore
    public RexNode getPattern() {
        return this.pattern;
    }

    @JsonIgnore
    public Map<String, RexNode> getPatternDefinitions() {
        return this.patternDefinitions;
    }

    @JsonIgnore
    public Map<String, RexNode> getMeasures() {
        return this.measures;
    }

    @JsonIgnore
    public RexNode getAfter() {
        return this.after;
    }

    @JsonIgnore
    public Map<String, SortedSet<String>> getSubsets() {
        return this.subsets;
    }

    @JsonIgnore
    public boolean isAllRows() {
        return this.allRows;
    }

    @JsonIgnore
    public PartitionSpec getPartition() {
        return this.partition;
    }

    @JsonIgnore
    public SortSpec getOrderKeys() {
        return this.orderKeys;
    }

    @JsonIgnore
    public Optional<RexNode> getInterval() {
        return Optional.ofNullable(this.interval);
    }

    public String toString() {
        return "Match{pattern=" + this.pattern + ", patternDefinitions=" + this.patternDefinitions + ", measures=" + this.measures + ", after=" + this.after + ", subsets=" + this.subsets + ", allRows=" + this.allRows + ", partition=" + this.partition + ", orderKeys=" + this.orderKeys + ", interval=" + this.interval + "}";
    }
}

