/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;

@Internal
final class ResolvedCatalogTableJsonSerializer
extends StdSerializer<ResolvedCatalogTable> {
    private static final long serialVersionUID = 1L;
    static final String SERIALIZE_OPTIONS = "serialize_options";
    static final String RESOLVED_SCHEMA = "schema";
    static final String DISTRIBUTION = "distribution";
    static final String PARTITION_KEYS = "partitionKeys";
    static final String OPTIONS = "options";
    static final String COMMENT = "comment";

    ResolvedCatalogTableJsonSerializer() {
        super(ResolvedCatalogTable.class);
    }

    public void serialize(ResolvedCatalogTable resolvedCatalogTable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        boolean serializeOptions = serializerProvider.getAttribute((Object)SERIALIZE_OPTIONS) == null || (Boolean)serializerProvider.getAttribute((Object)SERIALIZE_OPTIONS) != false;
        ResolvedCatalogTableJsonSerializer.serialize(resolvedCatalogTable, serializeOptions, jsonGenerator, serializerProvider);
    }

    static void serialize(ResolvedCatalogTable resolvedCatalogTable, boolean serializeOptions, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        assert (resolvedCatalogTable.getTableKind() == CatalogBaseTable.TableKind.TABLE);
        jsonGenerator.writeStartObject();
        if (resolvedCatalogTable.getOrigin() instanceof ExternalCatalogTable) {
            throw new TableException("Cannot serialize the table as it's an external inline table. This might be caused by a usage of StreamTableEnvironment#fromDataStream or TableResult#collect, which are not supported in compiled plans.");
        }
        serializerProvider.defaultSerializeField(RESOLVED_SCHEMA, (Object)resolvedCatalogTable.getResolvedSchema(), jsonGenerator);
        if (resolvedCatalogTable.getDistribution().isPresent()) {
            jsonGenerator.writeObjectField(DISTRIBUTION, (Object)resolvedCatalogTable.getDistribution());
        }
        jsonGenerator.writeObjectField(PARTITION_KEYS, (Object)resolvedCatalogTable.getPartitionKeys());
        if (serializeOptions) {
            if (!resolvedCatalogTable.getComment().isEmpty()) {
                jsonGenerator.writeObjectField(COMMENT, (Object)resolvedCatalogTable.getComment());
            }
            try {
                jsonGenerator.writeObjectField(OPTIONS, (Object)resolvedCatalogTable.getOptions());
            }
            catch (Exception e) {
                throw new TableException(String.format("The table is not serializable as %s#getOptions() failed. It seems the table is not intended to be stored in a persisted plan. Either declare the table as a temporary table or use '%s' = '%s' / '%s' to only compile an identifier into the plan.", resolvedCatalogTable.getOrigin().getClass(), TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.SCHEMA.name(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER.name()), (Throwable)e);
            }
        }
        jsonGenerator.writeEndObject();
    }
}

