/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.ddl.SqlCreateMaterializedTable;
import org.apache.flink.sql.parser.ddl.SqlRefreshMode;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.MaterializedTableConfigOptions;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.materializedtable.CreateMaterializedTableOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.MaterializedTableUtils;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.utils.IntervalFreshnessUtils;

public class SqlCreateMaterializedTableConverter
implements SqlNodeConverter<SqlCreateMaterializedTable> {
    @Override
    public Operation convertSqlNode(SqlCreateMaterializedTable sqlCreateMaterializedTable, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateMaterializedTable.fullTableName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        String tableComment = OperationConverterUtils.getTableComment(sqlCreateMaterializedTable.getComment());
        HashMap options = new HashMap();
        sqlCreateMaterializedTable.getPropertyList().getList().forEach(p -> options.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        IntervalFreshness intervalFreshness = MaterializedTableUtils.getMaterializedTableFreshness(sqlCreateMaterializedTable.getFreshness());
        SqlRefreshMode sqlRefreshMode = null;
        if (sqlCreateMaterializedTable.getRefreshMode().isPresent()) {
            sqlRefreshMode = sqlCreateMaterializedTable.getRefreshMode().get().getValueAs(SqlRefreshMode.class);
        }
        CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode = MaterializedTableUtils.deriveLogicalRefreshMode(sqlRefreshMode);
        CatalogMaterializedTable.RefreshMode refreshMode = MaterializedTableUtils.deriveRefreshMode((Duration)context.getTableConfig().getRootConfiguration().get(MaterializedTableConfigOptions.MATERIALIZED_TABLE_FRESHNESS_THRESHOLD), IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)intervalFreshness), logicalRefreshMode);
        if (CatalogMaterializedTable.RefreshMode.FULL == refreshMode) {
            IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)intervalFreshness);
        }
        SqlNode validateQuery = context.getSqlValidator().validate(sqlCreateMaterializedTable.getAsQuery());
        PlannerQueryOperation queryOperation = new PlannerQueryOperation(context.toRelRoot(validateQuery).project(), () -> context.toQuotedSqlString(validateQuery));
        String definitionQuery = context.expandSqlIdentifiers(queryOperation.asSerializableString());
        ResolvedSchema resolvedSchema = queryOperation.getResolvedSchema();
        Schema.Builder builder = Schema.newBuilder().fromResolvedSchema(resolvedSchema);
        List<String> partitionKeys = sqlCreateMaterializedTable.getPartitionKeyList().getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        SqlCreateMaterializedTableConverter.verifyPartitioningColumnsExist(resolvedSchema, partitionKeys, options.keySet().stream().filter(k -> k.startsWith("partition.fields")).collect(Collectors.toSet()));
        sqlCreateMaterializedTable.getTableConstraint().ifPresent(sqlTableConstraint -> SqlCreateMaterializedTableConverter.verifyAndBuildPrimaryKey(builder, resolvedSchema, sqlTableConstraint));
        CatalogMaterializedTable materializedTable = CatalogMaterializedTable.newBuilder().schema(builder.build()).comment(tableComment).partitionKeys(partitionKeys).options(options).definitionQuery(definitionQuery).freshness(intervalFreshness).logicalRefreshMode(logicalRefreshMode).refreshMode(refreshMode).refreshStatus(CatalogMaterializedTable.RefreshStatus.INITIALIZING).build();
        return new CreateMaterializedTableOperation(identifier, context.getCatalogManager().resolveCatalogMaterializedTable(materializedTable));
    }

    private static void verifyPartitioningColumnsExist(ResolvedSchema resolvedSchema, List<String> partitionKeys, Set<String> partitionFieldOptions) {
        for (String partitionKey : partitionKeys) {
            if (resolvedSchema.getColumn(partitionKey).isPresent()) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the query schema. Available columns: [%s].", partitionKey, resolvedSchema.getColumnNames().stream().collect(Collectors.joining("', '", "'", "'"))));
        }
        for (String partitionOption : partitionFieldOptions) {
            String partitionKey = partitionOption.substring("partition.fields".length() + 1, partitionOption.length() - ("date-formatter".length() + 1));
            if (!partitionKeys.contains(partitionKey)) {
                throw new ValidationException(String.format("Column '%s' referenced by materialized table option '%s' isn't a partition column. Available partition columns: [%s].", partitionKey, partitionOption, partitionKeys.stream().collect(Collectors.joining("', '", "'", "'"))));
            }
            LogicalType partitionKeyType = ((Column)resolvedSchema.getColumn(partitionKey).get()).getDataType().getLogicalType();
            if (partitionKeyType.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) continue;
            throw new ValidationException(String.format("Materialized table option '%s' only supports referring to char, varchar and string type partition column. Column %s type is %s.", partitionOption, partitionKey, partitionKeyType.asSummaryString()));
        }
    }

    private static void verifyAndBuildPrimaryKey(Schema.Builder schemaBuilder, ResolvedSchema resolvedSchema, SqlTableConstraint sqlTableConstraint) {
        try {
            SqlConstraintValidator.validate(sqlTableConstraint);
        }
        catch (SqlValidateException e) {
            throw new ValidationException(String.format("Primary key validation failed: %s.", e.getMessage()), (Throwable)e);
        }
        List<String> primaryKeyColumns = Arrays.asList(sqlTableConstraint.getColumnNames());
        for (String columnName : primaryKeyColumns) {
            Optional columnOptional = resolvedSchema.getColumn(columnName);
            if (!columnOptional.isPresent()) {
                throw new ValidationException(String.format("Primary key column '%s' not defined in the query schema. Available columns: [%s].", columnName, resolvedSchema.getColumnNames().stream().collect(Collectors.joining("', '", "'", "'"))));
            }
            if (!((Column)columnOptional.get()).getDataType().getLogicalType().isNullable()) continue;
            throw new ValidationException(String.format("Could not create a PRIMARY KEY with nullable column '%s'.\nA PRIMARY KEY column must be declared on non-nullable physical columns.", columnName));
        }
        String constraintName = sqlTableConstraint.getConstraintName().orElseGet(() -> primaryKeyColumns.stream().collect(Collectors.joining("_", "PK_", "")));
        schemaBuilder.primaryKeyNamed(constraintName, primaryKeyColumns);
    }
}

