/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class NumericToBooleanCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, Boolean> {
    static final NumericToBooleanCastRule INSTANCE = new NumericToBooleanCastRule();

    private NumericToBooleanCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.NUMERIC).target(LogicalTypeRoot.BOOLEAN).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (inputLogicalType.is(LogicalTypeRoot.DECIMAL)) {
            return CastRuleUtils.staticCall(BuiltInMethods.DECIMAL_TO_BOOLEAN(), inputTerm);
        }
        return inputTerm + " != 0";
    }
}

