/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.RexSetSemanticsTableCall;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlSessionTableFunction;
import org.apache.flink.util.Preconditions;

@Internal
public class FlinkConvertletTable
implements SqlRexConvertletTable {
    public static final FlinkConvertletTable INSTANCE = new FlinkConvertletTable();

    private FlinkConvertletTable() {
    }

    @Override
    public SqlRexConvertlet get(SqlCall call) {
        if (call.getOperator().isName("TRY_CAST", false)) {
            return this::convertTryCast;
        }
        if (this.isSetSemanticsWindowTableFunction(call)) {
            return this::convertSetSemanticsWindowTableFunction;
        }
        return StandardConvertletTable.INSTANCE.get(call);
    }

    private RexNode convertTryCast(SqlRexContext cx, SqlCall call) {
        RelDataType type;
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        Object leftNode = call.operand(0);
        Object rightNode = call.operand(1);
        RexNode valueRex = cx.convertExpression((SqlNode)leftNode);
        if (rightNode instanceof SqlIntervalQualifier) {
            type = typeFactory.createSqlIntervalType((SqlIntervalQualifier)rightNode);
        } else if (rightNode instanceof SqlDataTypeSpec) {
            SqlDataTypeSpec dataType = (SqlDataTypeSpec)rightNode;
            type = dataType.deriveType(cx.getValidator());
            if (type == null) {
                type = cx.getValidator().getValidatedNodeType(dataType.getTypeName());
            }
        } else {
            throw new IllegalStateException("Invalid right argument type for TRY_CAST: " + rightNode);
        }
        type = typeFactory.createTypeWithNullability(type, true);
        if (SqlUtil.isNullLiteral(leftNode, false)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)cx.getValidator();
            validator.setValidatedNodeType((SqlNode)leftNode, type);
            return cx.convertExpression((SqlNode)leftNode);
        }
        return cx.getRexBuilder().makeCall(type, FlinkSqlOperatorTable.TRY_CAST, Collections.singletonList(valueRex));
    }

    private boolean isSetSemanticsWindowTableFunction(SqlCall call) {
        if (!(call.getOperator() instanceof SqlWindowTableFunction)) {
            return false;
        }
        List<SqlNode> operands = call.getOperandList();
        return !operands.isEmpty() && operands.get(0).getKind() == SqlKind.SET_SEMANTICS_TABLE;
    }

    private RexNode convertSetSemanticsWindowTableFunction(SqlRexContext cx, SqlCall call) {
        Preconditions.checkArgument((boolean)(call.getOperator() instanceof SqlSessionTableFunction), (Object)"Currently, only the SESSION table function is supported in Set Semantics PTF.");
        SqlSessionTableFunction fun = (SqlSessionTableFunction)call.getOperator();
        List<SqlNode> operands = call.getOperandList();
        SqlBasicCall setSemanticsPTFCall = (SqlBasicCall)operands.get(0);
        SqlNodeList partitionKeys = (SqlNodeList)setSemanticsPTFCall.operand(1);
        SqlNodeList orderKeys = (SqlNodeList)setSemanticsPTFCall.operand(2);
        Preconditions.checkArgument((boolean)orderKeys.isEmpty(), (Object)"SESSION table function does not support order keys.");
        RexCall resolvedCall = (RexCall)StandardConvertletTable.INSTANCE.convertWindowFunction(cx, fun, call);
        int[] partitionKeyRefs = this.getPartitionKeyIndices(cx, partitionKeys);
        resolvedCall = new RexSetSemanticsTableCall(resolvedCall.getType(), resolvedCall.getOperator(), resolvedCall.getOperands(), partitionKeyRefs, new int[0]);
        return resolvedCall;
    }

    private int[] getPartitionKeyIndices(SqlRexContext cx, SqlNodeList partitions) {
        int[] result = new int[partitions.size()];
        for (int i = 0; i < partitions.getList().size(); ++i) {
            RexNode expr = cx.convertExpression(partitions.get(i));
            result[i] = FlinkConvertletTable.parseFieldIdx(expr);
        }
        return result;
    }

    private static int parseFieldIdx(RexNode e) {
        if (SqlKind.INPUT_REF == e.getKind()) {
            RexInputRef ref = (RexInputRef)e;
            return ref.getIndex();
        }
        throw new TableException("Unsupported partition key with type: " + e.getKind());
    }
}

