/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlCreateView
extends SqlCreate {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_VIEW", SqlKind.CREATE_VIEW);
    private final SqlIdentifier viewName;
    private final SqlNodeList fieldList;
    private final SqlNode query;
    private final boolean isTemporary;
    @Nullable
    private final SqlCharStringLiteral comment;
    @Nullable
    private final SqlNodeList properties;

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, boolean replace, boolean isTemporary, boolean ifNotExists, SqlCharStringLiteral comment, SqlNodeList properties) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.viewName = Objects.requireNonNull(viewName, "viewName should not be null");
        this.fieldList = Objects.requireNonNull(fieldList, "fieldList should not be null");
        this.query = Objects.requireNonNull(query, "query should not be null");
        this.isTemporary = Objects.requireNonNull(Boolean.valueOf(isTemporary), "isTemporary should not be null");
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = new ArrayList<SqlNode>();
        ops.add(this.viewName);
        ops.add(this.fieldList);
        ops.add(this.query);
        ops.add(SqlLiteral.createBoolean(this.getReplace(), SqlParserPos.ZERO));
        return ops;
    }

    public SqlIdentifier getViewName() {
        return this.viewName;
    }

    public SqlNodeList getFieldList() {
        return this.fieldList;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<SqlNodeList> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary()) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("VIEW");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.viewName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList.size() > 0) {
            this.fieldList.unparse(writer, 1, rightPrec);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public String[] fullViewName() {
        return this.viewName.names.toArray(new String[0]);
    }
}

