/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata.janino;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.DelegatingMetadataRel;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.janino.CacheUtil;
import org.apache.calcite.rel.metadata.janino.CodeGeneratorUtil;
import org.apache.calcite.rel.metadata.janino.DescriptiveCacheKey;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

class CacheGeneratorUtil {
    private CacheGeneratorUtil() {
    }

    static void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
        CacheGeneratorUtil.selectStrategy(method).cacheProperties(buff, method, methodIndex);
    }

    static void cachedMethod(StringBuilder buff, Method method, int methodIndex) {
        String delRelClass = DelegatingMetadataRel.class.getName();
        buff.append("  public ").append(method.getReturnType().getName()).append(" ").append(method.getName()).append("(\n").append("      ").append(RelNode.class.getName()).append(" r,\n").append("      ").append(RelMetadataQuery.class.getName()).append(" mq");
        CodeGeneratorUtil.paramList(buff, method).append(") {\n").append("    while (r instanceof ").append(delRelClass).append(") {\n").append("      r = ((").append(delRelClass).append(") r).getMetadataDelegateRel();\n").append("    }\n").append("    final Object key;\n");
        CacheGeneratorUtil.selectStrategy(method).cacheKeyBlock(buff, method, methodIndex);
        buff.append("    final Object v = mq.map.get(r, key);\n").append("    if (v != null) {\n").append("      if (v == ").append(NullSentinel.class.getName()).append(".ACTIVE) {\n").append("        throw new ").append(CyclicMetadataException.class.getName()).append("();\n").append("      }\n").append("      if (v == ").append(NullSentinel.class.getName()).append(".INSTANCE) {\n").append("        return null;\n").append("      }\n").append("      return (").append(method.getReturnType().getName()).append(") v;\n").append("    }\n").append("    mq.map.put(r, key,").append(NullSentinel.class.getName()).append(".ACTIVE);\n").append("    try {\n").append("      final ").append(method.getReturnType().getName()).append(" x = ").append(method.getName()).append("_(r, mq");
        CodeGeneratorUtil.argList(buff, method).append(");\n").append("      mq.map.put(r, key, ").append(NullSentinel.class.getName()).append(".mask(x));\n").append("      return x;\n").append("    } catch (").append(Exception.class.getName()).append(" e) {\n").append("      mq.map.row(r).clear();\n").append("      throw e;\n").append("    }\n").append("  }\n").append("\n");
    }

    private static void appendKeyName(StringBuilder buff, int methodIndex) {
        buff.append("methodKey").append(methodIndex);
    }

    private static void appendKeyName(StringBuilder buff, int methodIndex, String arg) {
        buff.append("methodKey").append(methodIndex).append(arg);
    }

    private static CacheKeyStrategy selectStrategy(Method method) {
        switch (method.getParameterCount()) {
            case 2: {
                return CacheKeyStrategy.NO_ARG;
            }
            case 3: {
                Class<?> clazz = method.getParameterTypes()[2];
                if (clazz.equals(Boolean.TYPE)) {
                    return CacheKeyStrategy.BOOLEAN_ARG;
                }
                if (Enum.class.isAssignableFrom(clazz)) {
                    return CacheKeyStrategy.ENUM_ARG;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return CacheKeyStrategy.INT_ARG;
                }
                return CacheKeyStrategy.DEFAULT;
            }
        }
        return CacheKeyStrategy.DEFAULT;
    }

    private static StringBuilder newDescriptiveCacheKey(StringBuilder buff, Method method, String arg) {
        return buff.append("      new ").append(DescriptiveCacheKey.class.getName()).append("(\"").append(method.getReturnType().getSimpleName()).append(" ").append(method.getDeclaringClass().getSimpleName()).append(".").append(method.getName()).append("(").append(arg).append(")").append("\");\n");
    }

    private static enum CacheKeyStrategy {
        DEFAULT{

            @Override
            void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
                String args = ImmutableList.copyOf(method.getParameterTypes()).stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
                buff.append("  private final Object ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append(" =\n");
                CacheGeneratorUtil.newDescriptiveCacheKey(buff, method, args);
            }

            @Override
            void cacheKeyBlock(StringBuilder buff, Method method, int methodIndex) {
                buff.append("    key = ").append((method.getParameterTypes().length < 6 ? FlatLists.class : ImmutableList.class).getName()).append(".of(");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                this.safeArgList(buff, method).append(");\n");
            }

            private StringBuilder safeArgList(StringBuilder buff, Method method) {
                for (Ord<Class<?>> t : Ord.zip(method.getParameterTypes()).subList(2, method.getParameterCount())) {
                    if (Primitive.is((Type)t.e) || RexNode.class.isAssignableFrom((Class)t.e)) {
                        buff.append(", a").append(t.i);
                        continue;
                    }
                    buff.append(", ").append(NullSentinel.class.getName()).append(".mask(a").append(t.i).append(")");
                }
                return buff;
            }
        }
        ,
        NO_ARG{

            @Override
            void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
                buff.append("  private final Object ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append(" =\n");
                CacheGeneratorUtil.newDescriptiveCacheKey(buff, method, "");
            }

            @Override
            void cacheKeyBlock(StringBuilder buff, Method method, int methodIndex) {
                buff.append("    key = ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append(";\n");
            }
        }
        ,
        ENUM_ARG{

            @Override
            void cacheKeyBlock(StringBuilder buff, Method method, int methodIndex) {
                buff.append("    if (a2 == null) {\n").append("      key = ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "Null");
                buff.append(";\n").append("    } else {\n").append("      key = ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append("[a2.ordinal()];\n").append("    }\n");
            }

            @Override
            void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
                assert (method.getParameterCount() == 3);
                Class<?> clazz = method.getParameterTypes()[2];
                assert (Enum.class.isAssignableFrom(clazz));
                buff.append("  private final Object ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "Null");
                buff.append(" =\n");
                CacheGeneratorUtil.newDescriptiveCacheKey(buff, method, "null").append("  private final Object[] ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append(" =\n").append("      ").append(CacheUtil.class.getName()).append(".generateEnum(\"").append(method.getReturnType().getSimpleName()).append(" ").append(method.getName()).append("\", ").append(clazz.getName()).append(".values());\n");
            }
        }
        ,
        BOOLEAN_ARG{

            @Override
            void cacheKeyBlock(StringBuilder buff, Method method, int methodIndex) {
                buff.append("    key = a2 ? ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "True");
                buff.append(" : ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "False");
                buff.append(";\n");
            }

            @Override
            void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
                assert (method.getParameterCount() == 3);
                assert (method.getParameterTypes()[2].equals(Boolean.TYPE));
                buff.append("  private final Object ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "True");
                buff.append(" =\n");
                CacheGeneratorUtil.newDescriptiveCacheKey(buff, method, "true").append("  private final Object ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "False");
                buff.append(" =\n");
                CacheGeneratorUtil.newDescriptiveCacheKey(buff, method, "false");
            }
        }
        ,
        INT_ARG{
            private final int min = -256;
            private final int max = 256;

            @Override
            void cacheKeyBlock(StringBuilder buff, Method method, int methodIndex) {
                assert (method.getParameterCount() == 3);
                assert (method.getParameterTypes()[2] == Integer.TYPE);
                buff.append("    if (a2 >= ").append(-256).append(" && a2 < ").append(256).append(") {\n").append("      key = ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "FlyWeight");
                buff.append("[a2 + ").append(256).append("];\n").append("    } else {\n").append("      key = ").append(FlatLists.class.getName()).append(".of(");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex);
                buff.append(", a2);\n").append("    }\n");
            }

            @Override
            void cacheProperties(StringBuilder buff, Method method, int methodIndex) {
                DEFAULT.cacheProperties(buff, method, methodIndex);
                buff.append("  private final Object[] ");
                CacheGeneratorUtil.appendKeyName(buff, methodIndex, "FlyWeight");
                buff.append(" =\n").append("      ").append(CacheUtil.class.getName()).append(".generateRange(\"").append(method.getReturnType().getName()).append(" ").append(method.getName()).append("\", ").append(-256).append(", ").append(256).append(");\n");
            }
        };


        abstract void cacheKeyBlock(StringBuilder var1, Method var2, int var3);

        abstract void cacheProperties(StringBuilder var1, Method var2, int var3);
    }
}

