/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Litmus;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class LogicalSnapshot
extends Snapshot {
    public LogicalSnapshot(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, RexNode period) {
        super(cluster, traitSet, hints, input, period);
    }

    public LogicalSnapshot(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode period) {
        super(cluster, traitSet, ImmutableList.of(), input, period);
    }

    @Override
    public Snapshot copy(RelTraitSet traitSet, RelNode input, RexNode period) {
        return new LogicalSnapshot(this.getCluster(), traitSet, this.hints, input, period);
    }

    public static LogicalSnapshot create(RelNode input, RexNode period) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.snapshot(mq, input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.snapshot(mq, input));
        return new LogicalSnapshot(cluster, traitSet, input, period);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        SqlTypeName periodTypeName = this.getPeriod().getType().getSqlTypeName();
        if (periodTypeName != SqlTypeName.TIMESTAMP && periodTypeName != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return litmus.fail("The system time period specification expects TIMESTAMP or TIMESTAMP WITH LOCAL TIME ZONE type but is '" + periodTypeName + "'", new Object[0]);
        }
        return litmus.succeed();
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalSnapshot(this.getCluster(), this.traitSet, hintList, this.input, this.getPeriod());
    }
}

