/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Grouping;
import org.apache.calcite.linq4j.GroupingImpl;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Lookup;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.KeyFor;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

class LookupImpl<K, V>
extends AbstractEnumerable<Grouping<K, V>>
implements Lookup<K, V> {
    private final Map<K, List<V>> map;

    LookupImpl(Map<K, List<V>> map) {
        this.map = map;
    }

    @Override
    public Enumerator<Grouping<K, V>> enumerator() {
        return new Enumerator<Grouping<K, V>>(){
            Enumerator<Map.Entry<K, List<V>>> enumerator;
            {
                this.enumerator = Linq4j.enumerator(LookupImpl.this.map.entrySet());
            }

            @Override
            public Grouping<K, V> current() {
                Map.Entry keyAndList = this.enumerator.current();
                return new GroupingImpl(keyAndList.getKey(), keyAndList.getValue());
            }

            @Override
            public boolean moveNext() {
                return this.enumerator.moveNext();
            }

            @Override
            public void reset() {
                this.enumerator.reset();
            }

            @Override
            public void close() {
                this.enumerator.close();
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        List list = (List)value;
        return this.map.containsValue(list);
    }

    @Override
    public @Nullable Enumerable<V> get(@Nullable Object key) {
        List<V> list = this.map.get(key);
        return list == null ? null : Linq4j.asEnumerable(list);
    }

    @Override
    public @Nullable Enumerable<V> put(K key, Enumerable<V> value) {
        List list = this.map.put(key, value.toList());
        return list == null ? null : Linq4j.asEnumerable(list);
    }

    @Override
    public @Nullable Enumerable<V> remove(@Nullable Object key) {
        List<V> list = this.map.remove(key);
        return list == null ? null : Linq4j.asEnumerable(list);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Enumerable<V>> m3) {
        for (Map.Entry<K, Enumerable<V>> entry : m3.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue().toList());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<@KeyFor(value={"this"}) K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Enumerable<V>> values() {
        final Collection<List<V>> lists = this.map.values();
        return new AbstractCollection<Enumerable<V>>(){

            @Override
            public Iterator<Enumerable<V>> iterator() {
                return new Iterator<Enumerable<V>>(){
                    final Iterator<List<V>> iterator;
                    {
                        this.iterator = lists.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Enumerable<V> next() {
                        return Linq4j.asEnumerable(this.iterator.next());
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return lists.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<@KeyFor(value={"this"}) K, Enumerable<V>>> entrySet() {
        final Set<Map.Entry<@KeyFor(value={"map"}) K, List<V>>> entries = this.map.entrySet();
        return new AbstractSet<Map.Entry<K, Enumerable<V>>>(){

            @Override
            public Iterator<Map.Entry<K, Enumerable<V>>> iterator() {
                final Iterator iterator = entries.iterator();
                return new Iterator<Map.Entry<K, Enumerable<V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Enumerable<V>> next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new AbstractMap.SimpleEntry(entry.getKey(), Linq4j.asEnumerable((List)entry.getValue()));
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return entries.size();
            }
        };
    }

    @Override
    public <TResult> Enumerable<TResult> applyResultSelector(final Function2<K, Enumerable<V>, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                final Enumerator groupingEnumerator = LookupImpl.this.enumerator();
                return new Enumerator<TResult>(){

                    @Override
                    public TResult current() {
                        Grouping grouping = (Grouping)groupingEnumerator.current();
                        return resultSelector.apply(grouping.getKey(), grouping);
                    }

                    @Override
                    public boolean moveNext() {
                        return groupingEnumerator.moveNext();
                    }

                    @Override
                    public void reset() {
                        groupingEnumerator.reset();
                    }

                    @Override
                    public void close() {
                        groupingEnumerator.close();
                    }
                };
            }
        };
    }

    public Enumerable<V> valuesEnumerable() {
        return new AbstractEnumerable<V>(){

            @Override
            public Enumerator<V> enumerator() {
                final Enumerator listEnumerator = Linq4j.iterableEnumerator(LookupImpl.this.values());
                return new Enumerator<V>(){
                    Enumerator<V> enumerator = Linq4j.emptyEnumerator();

                    @Override
                    public V current() {
                        return this.enumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.enumerator.moveNext()) {
                            this.enumerator.close();
                            if (!listEnumerator.moveNext()) {
                                this.enumerator = Linq4j.emptyEnumerator();
                                return false;
                            }
                            this.enumerator = ((Enumerable)listEnumerator.current()).enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        listEnumerator.reset();
                        this.enumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }
}

