/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class TableFunctionScanNode
implements Node {
    private final Scalar scalar;
    private final Context context;
    private final Sink sink;
    private final Function1<?, Row> mapFn;

    private TableFunctionScanNode(Compiler compiler, TableFunctionScan rel) {
        RelDataType rowType = rel.getRowType();
        this.scalar = compiler.compile(ImmutableList.of(rel.getCall()), rowType);
        this.context = compiler.createContext();
        this.sink = compiler.sink(rel);
        this.mapFn = rowType.getFieldCount() == 1 && rel.getElementType() != Object[].class ? Row::of : Row::asCopy;
    }

    @Override
    public void run() throws InterruptedException {
        Object o = this.scalar.execute(this.context);
        if (o instanceof Enumerable) {
            Enumerator enumerator = ((Enumerable)o).select(this.mapFn).enumerator();
            while (enumerator.moveNext()) {
                this.sink.send((Row)enumerator.current());
            }
        }
    }

    static TableFunctionScanNode create(Compiler compiler, TableFunctionScan rel) {
        Function function;
        SqlOperator operator;
        RexNode call = rel.getCall();
        if (call instanceof RexCall && (operator = ((RexCall)call).getOperator()) instanceof SqlUserDefinedTableFunction && (function = ((SqlUserDefinedTableFunction)operator).function) instanceof TableFunctionImpl) {
            return new TableFunctionScanNode(compiler, rel);
        }
        throw new AssertionError((Object)("cannot convert table function scan " + rel.getCall() + " to enumerable"));
    }
}

