/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PartitionTempFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionTempFileManager.class);
    private static final String TASK_DIR_PREFIX = "task-";
    private static final String ATTEMPT_PREFIX = "attempt-";
    private static final String TASK_DIR_FORMAT = "%s%d-%s%d";
    private static final Pattern TASK_DIR_PATTERN = Pattern.compile("task-(\\d+)-attempt-(\\d+)");
    private final int taskNumber;
    private final Path taskTmpDir;
    private final OutputFileConfig outputFileConfig;
    private transient int nameCounter = 0;

    public PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber, int attemptNumber) throws IOException {
        this(factory, tmpPath, taskNumber, attemptNumber, new OutputFileConfig("", ""));
    }

    public PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber, int attemptNumber, OutputFileConfig outputFileConfig) throws IOException {
        this.taskNumber = taskNumber;
        this.outputFileConfig = outputFileConfig;
        String taskTmpDirName = String.format(TASK_DIR_FORMAT, TASK_DIR_PREFIX, taskNumber, ATTEMPT_PREFIX, attemptNumber);
        this.taskTmpDir = new Path(tmpPath, taskTmpDirName);
        factory.create(this.taskTmpDir.toUri()).delete(this.taskTmpDir, true);
    }

    public Path createPartitionDir(String ... partitions) {
        Path parentPath = this.taskTmpDir;
        for (String dir : partitions) {
            parentPath = new Path(parentPath, dir);
        }
        return new Path(parentPath, this.newFileName());
    }

    private String newFileName() {
        return String.format("%s-%s-file-%d%s", this.outputFileConfig.getPartPrefix(), PartitionTempFileManager.taskName(this.taskNumber), this.nameCounter++, this.outputFileConfig.getPartSuffix());
    }

    private static String taskName(int task) {
        return TASK_DIR_PREFIX + task;
    }

    public static List<Path> listTaskTemporaryPaths(FileSystem fs, Path basePath, BiPredicate<Integer, Integer> taskAttemptFilter) throws Exception {
        ArrayList<Path> taskTmpPaths = new ArrayList<Path>();
        if (fs.exists(basePath)) {
            for (FileStatus taskStatus : fs.listStatus(basePath)) {
                String taskDirName = taskStatus.getPath().getName();
                Matcher matcher = TASK_DIR_PATTERN.matcher(taskDirName);
                if (!matcher.matches()) continue;
                int subtaskIndex = Integer.parseInt(matcher.group(1));
                int attemptNumber = Integer.parseInt(matcher.group(2));
                if (!taskAttemptFilter.test(subtaskIndex, attemptNumber)) continue;
                taskTmpPaths.add(taskStatus.getPath());
            }
        } else {
            LOG.warn("The path {} doesn't exist. Maybe no data is generated in the path and the path is not created.", (Object)basePath);
        }
        return taskTmpPaths;
    }

    public static Map<LinkedHashMap<String, String>, List<Path>> collectPartSpecToPaths(FileSystem fs, List<Path> taskPaths, int partColSize) {
        HashMap<LinkedHashMap<String, String>, List<Path>> specToPaths = new HashMap<LinkedHashMap<String, String>, List<Path>>();
        for (Path taskPath : taskPaths) {
            PartitionPathUtils.searchPartSpecAndPaths((FileSystem)fs, (Path)taskPath, (int)partColSize).forEach(tuple2 -> specToPaths.compute((LinkedHashMap)tuple2.f0, (spec, paths) -> {
                paths = paths == null ? new ArrayList() : paths;
                paths.add((Path)tuple2.f1);
                return paths;
            }));
        }
        return specToPaths;
    }
}

