/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.FSDataInputStream;

@PublicEvolving
public interface StreamFormat<T>
extends Serializable,
ResultTypeQueryable<T> {
    public static final ConfigOption<MemorySize> FETCH_IO_SIZE = ConfigOptions.key((String)"source.file.stream.io-fetch-size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)1L)).withDescription("The approximate of bytes per fetch that is passed from the I/O thread to file reader.");

    public Reader<T> createReader(Configuration var1, FSDataInputStream var2, long var3, long var5) throws IOException;

    public Reader<T> restoreReader(Configuration var1, FSDataInputStream var2, long var3, long var5, long var7) throws IOException;

    public boolean isSplittable();

    public TypeInformation<T> getProducedType();

    @PublicEvolving
    public static interface Reader<T>
    extends Closeable {
        @Nullable
        public T read() throws IOException;

        @Override
        public void close() throws IOException;

        @Nullable
        default public CheckpointedPosition getCheckpointedPosition() {
            return null;
        }
    }
}

