/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.compression.StandardDeCompressors;
import org.apache.flink.connector.file.src.enumerate.BlockSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.enumerate.DefaultFileFilter;
import org.apache.flink.connector.file.src.enumerate.RegexFileFilter;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

@Internal
public class BlockSplittingRecursiveAllDirEnumerator
extends BlockSplittingRecursiveEnumerator {
    private final DefaultFileFilter hiddenDirFilter = new DefaultFileFilter();

    public BlockSplittingRecursiveAllDirEnumerator(String pathPattern) {
        this(new RegexFileFilter(pathPattern), StandardDeCompressors.getCommonSuffixes().toArray(new String[0]));
    }

    public BlockSplittingRecursiveAllDirEnumerator(Predicate<Path> fileFilter, String[] nonSplittableFileSuffixes) {
        super(fileFilter, nonSplittableFileSuffixes);
    }

    @Override
    protected void addSplitsForPath(FileStatus fileStatus, FileSystem fs, ArrayList<FileSourceSplit> target) throws IOException {
        if (fileStatus.isDir()) {
            FileStatus[] containedFiles;
            if (!this.hiddenDirFilter.test(fileStatus.getPath())) {
                return;
            }
            for (FileStatus containedStatus : containedFiles = fs.listStatus(fileStatus.getPath())) {
                this.addSplitsForPath(containedStatus, fs, target);
            }
        } else if (this.fileFilter.test(fileStatus.getPath())) {
            this.convertToSourceSplits(fileStatus, fs, target);
            return;
        }
    }
}

