/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.FileCompactStrategy;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class CompactCoordinator
extends AbstractStreamOperator<CompactorRequest>
implements OneInputStreamOperator<CommittableMessage<FileSinkCommittable>, CompactorRequest>,
BoundedOneInput {
    static final ListStateDescriptor<byte[]> REMAINING_COMMITTABLE_RAW_STATES_DESC = new ListStateDescriptor("remaining_compact_commit_raw_state", (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
    private final FileCompactStrategy strategy;
    private final SimpleVersionedSerializer<FileSinkCommittable> committableSerializer;
    private final Map<String, CompactorRequest> packingRequests = new HashMap<String, CompactorRequest>();
    private final Map<String, CompactTrigger> triggers = new HashMap<String, CompactTrigger>();
    private ListState<FileSinkCommittable> remainingCommittableState;

    public CompactCoordinator(FileCompactStrategy strategy, SimpleVersionedSerializer<FileSinkCommittable> committableSerializer) {
        this.strategy = strategy;
        this.committableSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(committableSerializer);
    }

    public void processElement(StreamRecord<CommittableMessage<FileSinkCommittable>> element) throws Exception {
        FileSinkCommittable committable;
        CommittableMessage message = (CommittableMessage)element.getValue();
        if (message instanceof CommittableWithLineage && this.packAndTrigger(committable = (FileSinkCommittable)((CommittableWithLineage)element.getValue()).getCommittable())) {
            this.fireAndPurge(committable.getBucketId());
        }
    }

    private boolean packAndTrigger(FileSinkCommittable committable) {
        String bucketId = committable.getBucketId();
        CompactorRequest bucketRequest = this.packingRequests.computeIfAbsent(bucketId, CompactorRequest::new);
        if (committable.hasInProgressFileToCleanup() || committable.hasCompactedFileToCleanup()) {
            Preconditions.checkState((!committable.hasPendingFile() ? 1 : 0) != 0);
            bucketRequest.addToPassthrough(committable);
            return false;
        }
        if (!committable.hasPendingFile()) {
            throw new RuntimeException("Committable to compact has no content.");
        }
        CompactTrigger trigger = this.triggers.computeIfAbsent(bucketId, id -> new CompactTrigger(this.strategy));
        CompactTriggerResult triggerResult = trigger.onElement(committable);
        switch (triggerResult) {
            case PASS_THROUGH: {
                bucketRequest.addToPassthrough(committable);
                return false;
            }
            case CONTINUE: {
                bucketRequest.addToCompact(committable);
                return false;
            }
            case FIRE_AND_PURGE: {
                bucketRequest.addToCompact(committable);
                return true;
            }
        }
        throw new RuntimeException("Unexpected trigger result:" + triggerResult);
    }

    private void fireAndPurge(String bucketId) {
        this.triggers.remove(bucketId);
        CompactorRequest request = this.packingRequests.remove(bucketId);
        if (request != null) {
            this.output.collect((Object)new StreamRecord((Object)request));
        }
    }

    public void endInput() throws Exception {
        for (CompactorRequest request : this.packingRequests.values()) {
            this.output.collect((Object)new StreamRecord((Object)request));
        }
        this.packingRequests.clear();
        this.triggers.clear();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        super.prepareSnapshotPreBarrier(checkpointId);
        ArrayList<String> bucketsToFire = new ArrayList<String>(this.triggers.size());
        for (Map.Entry<String, CompactTrigger> e : this.triggers.entrySet()) {
            String bucketId = e.getKey();
            CompactTrigger trigger = e.getValue();
            if (trigger.onCheckpoint(checkpointId) != CompactTriggerResult.FIRE_AND_PURGE) continue;
            bucketsToFire.add(bucketId);
        }
        bucketsToFire.forEach(this::fireAndPurge);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        List remainingCommittable = this.packingRequests.values().stream().flatMap(r -> r.getCommittableToCompact().stream()).collect(Collectors.toList());
        this.packingRequests.values().stream().flatMap(r -> r.getCommittableToPassthrough().stream()).forEach(remainingCommittable::add);
        this.remainingCommittableState.update(remainingCommittable);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.remainingCommittableState = new SimpleVersionedListState(context.getOperatorStateStore().getListState(REMAINING_COMMITTABLE_RAW_STATES_DESC), this.committableSerializer);
        Iterable stateRemaining = (Iterable)this.remainingCommittableState.get();
        if (stateRemaining != null) {
            for (FileSinkCommittable committable : stateRemaining) {
                if (!this.packAndTrigger(committable)) continue;
                this.fireAndPurge(committable.getBucketId());
            }
        }
    }

    static class CompactTrigger {
        private final long threshold;
        private final int numCheckpointsBeforeCompaction;
        private long size;
        private long triggeredCpId = -1L;

        CompactTrigger(FileCompactStrategy strategy) {
            this.threshold = strategy.getSizeThreshold();
            this.numCheckpointsBeforeCompaction = strategy.getNumCheckpointsBeforeCompaction();
        }

        public CompactTriggerResult onElement(FileSinkCommittable committable) {
            InProgressFileWriter.PendingFileRecoverable file = committable.getPendingFile();
            if (file == null) {
                return CompactTriggerResult.PASS_THROUGH;
            }
            if (file.getPath() == null || !file.getPath().getName().startsWith(".")) {
                return CompactTriggerResult.PASS_THROUGH;
            }
            long curSize = file.getSize();
            if (curSize < 0L) {
                return CompactTriggerResult.PASS_THROUGH;
            }
            if (this.threshold < 0L) {
                return CompactTriggerResult.CONTINUE;
            }
            this.size += curSize;
            return this.size >= this.threshold ? CompactTriggerResult.FIRE_AND_PURGE : CompactTriggerResult.CONTINUE;
        }

        public CompactTriggerResult onCheckpoint(long checkpointId) {
            if (this.numCheckpointsBeforeCompaction < 0) {
                return CompactTriggerResult.CONTINUE;
            }
            if (this.triggeredCpId < 0L) {
                this.triggeredCpId = checkpointId - 1L;
            }
            return checkpointId - this.triggeredCpId >= (long)this.numCheckpointsBeforeCompaction ? CompactTriggerResult.FIRE_AND_PURGE : CompactTriggerResult.CONTINUE;
        }
    }

    static enum CompactTriggerResult {
        CONTINUE,
        FIRE_AND_PURGE,
        PASS_THROUGH;

    }
}

