/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.cep.configuration.SharedBufferCacheConfig;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNodeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.RemovalCause;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterables;
import org.apache.flink.util.WrappingRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedBuffer<V> {
    private static final Logger LOG = LoggerFactory.getLogger(SharedBuffer.class);
    private static final String LEGACY_ENTRIES_STATE_NAME = "sharedBuffer-entries";
    private static final String ENTRIES_STATE_NAME = "sharedBuffer-entries-with-lockable-edges";
    private static final String EVENTS_STATE_NAME = "sharedBuffer-events";
    private static final String EVENTS_COUNT_STATE_NAME = "sharedBuffer-events-count";
    private final MapState<EventId, Lockable<V>> eventsBuffer;
    private final MapState<Long, Integer> eventsCount;
    private final MapState<NodeId, Lockable<SharedBufferNode>> entries;
    private final Cache<EventId, Lockable<V>> eventsBufferCache;
    private final Cache<NodeId, Lockable<SharedBufferNode>> entryCache;
    private final Timer cacheStatisticsTimer;

    @VisibleForTesting
    public SharedBuffer(KeyedStateStore stateStore, TypeSerializer<V> valueSerializer) {
        this(stateStore, valueSerializer, new SharedBufferCacheConfig());
    }

    public SharedBuffer(KeyedStateStore stateStore, TypeSerializer<V> valueSerializer, SharedBufferCacheConfig cacheConfig) {
        this.eventsBuffer = stateStore.getMapState(new MapStateDescriptor(EVENTS_STATE_NAME, (TypeSerializer)EventId.EventIdSerializer.INSTANCE, new Lockable.LockableTypeSerializer<V>(valueSerializer)));
        this.entries = stateStore.getMapState(new MapStateDescriptor(ENTRIES_STATE_NAME, (TypeSerializer)new NodeId.NodeIdSerializer(), new Lockable.LockableTypeSerializer(new SharedBufferNodeSerializer())));
        this.eventsCount = stateStore.getMapState(new MapStateDescriptor(EVENTS_COUNT_STATE_NAME, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE));
        this.eventsBufferCache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getEventsBufferCacheSlots()).removalListener(removalNotification -> {
            if (RemovalCause.SIZE == removalNotification.getCause()) {
                try {
                    this.eventsBuffer.put((Object)((EventId)removalNotification.getKey()), (Object)((Lockable)removalNotification.getValue()));
                }
                catch (Exception e) {
                    LOG.error("Error in putting value into eventsBuffer.", (Throwable)e);
                }
            }
        }).build();
        this.entryCache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getEntryCacheSlots()).removalListener(removalNotification -> {
            if (RemovalCause.SIZE == removalNotification.getCause()) {
                try {
                    this.entries.put((Object)((NodeId)removalNotification.getKey()), (Object)((Lockable)removalNotification.getValue()));
                }
                catch (Exception e) {
                    LOG.error("Error in putting value into entries.", (Throwable)e);
                }
            }
        }).build();
        this.cacheStatisticsTimer = new Timer();
        this.cacheStatisticsTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                LOG.info("Statistics details of eventsBufferCache: {}, statistics details of entryCache: {}.", (Object)SharedBuffer.this.eventsBufferCache.stats(), (Object)SharedBuffer.this.entryCache.stats());
            }
        }, cacheConfig.getCacheStatisticsInterval().toMillis(), cacheConfig.getCacheStatisticsInterval().toMillis());
    }

    public void migrateOldState(KeyedStateBackend<?> stateBackend, ValueState<NFAState> computationStates) throws Exception {
        stateBackend.applyToAllKeys((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new MapStateDescriptor(LEGACY_ENTRIES_STATE_NAME, (TypeSerializer)new NodeId.NodeIdSerializer(), new Lockable.LockableTypeSerializer(new SharedBufferNode.SharedBufferNodeSerializer())), (key, state) -> {
            this.copyEntries((MapState<NodeId, Lockable<SharedBufferNode>>)state);
            state.entries().forEach(this::lockPredecessorEdges);
            state.clear();
            NFAState nfaState = (NFAState)computationStates.value();
            nfaState.getPartialMatches().forEach(computationState -> this.lockEdges(computationState.getPreviousBufferEntry(), computationState.getVersion()));
            nfaState.getCompletedMatches().forEach(computationState -> this.lockEdges(computationState.getPreviousBufferEntry(), computationState.getVersion()));
        });
    }

    private void copyEntries(MapState<NodeId, Lockable<SharedBufferNode>> state) throws Exception {
        state.entries().forEach(e -> {
            try {
                this.entries.put((Object)((NodeId)e.getKey()), (Object)((Lockable)e.getValue()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private void lockPredecessorEdges(Map.Entry<NodeId, Lockable<SharedBufferNode>> e) {
        SharedBufferNode oldNode = e.getValue().getElement();
        oldNode.getEdges().forEach(edge -> {
            SharedBufferEdge oldEdge = (SharedBufferEdge)edge.getElement();
            this.lockEdges(oldEdge.getTarget(), oldEdge.getDeweyNumber());
        });
    }

    private void lockEdges(NodeId nodeId, DeweyNumber version) {
        if (nodeId == null) {
            return;
        }
        try {
            SharedBufferNode newNode = (SharedBufferNode)((Lockable)this.entries.get((Object)nodeId)).getElement();
            newNode.getEdges().forEach(newEdge -> {
                if (version.isCompatibleWith(((SharedBufferEdge)newEdge.getElement()).getDeweyNumber())) {
                    newEdge.lock();
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public SharedBufferAccessor<V> getAccessor() {
        return new SharedBufferAccessor(this);
    }

    void advanceTime(long timestamp) throws Exception {
        Iterator iterator = this.eventsCount.keys().iterator();
        while (iterator.hasNext()) {
            Long next = (Long)iterator.next();
            if (next >= timestamp) continue;
            iterator.remove();
        }
        if (this.eventsCount.isEmpty()) {
            this.eventsCount.clear();
        }
    }

    EventId registerEvent(V value, long timestamp) throws Exception {
        Integer id = (Integer)this.eventsCount.get((Object)timestamp);
        if (id == null) {
            id = 0;
        }
        EventId eventId = new EventId(id, timestamp);
        Lockable<V> lockableValue = new Lockable<V>(value, 1);
        this.eventsCount.put((Object)timestamp, (Object)(id + 1));
        this.eventsBufferCache.put((Object)eventId, lockableValue);
        return eventId;
    }

    public boolean isEmpty() throws Exception {
        return Iterables.isEmpty(this.eventsBufferCache.asMap().keySet()) && Iterables.isEmpty((Iterable)this.eventsBuffer.keys());
    }

    public void releaseCacheStatisticsTimer() {
        if (this.cacheStatisticsTimer != null) {
            this.cacheStatisticsTimer.cancel();
        }
    }

    void upsertEvent(EventId eventId, Lockable<V> event) {
        this.eventsBufferCache.put((Object)eventId, event);
    }

    void upsertEntry(NodeId nodeId, Lockable<SharedBufferNode> entry) {
        this.entryCache.put((Object)nodeId, entry);
    }

    void removeEvent(EventId eventId) throws Exception {
        this.eventsBufferCache.invalidate((Object)eventId);
        this.eventsBuffer.remove((Object)eventId);
    }

    void removeEntry(NodeId nodeId) throws Exception {
        this.entryCache.invalidate((Object)nodeId);
        this.entries.remove((Object)nodeId);
    }

    Lockable<SharedBufferNode> getEntry(NodeId nodeId) {
        try {
            Lockable lockableFromCache = (Lockable)this.entryCache.getIfPresent((Object)nodeId);
            if (Objects.nonNull(lockableFromCache)) {
                return lockableFromCache;
            }
            Lockable lockableFromState = (Lockable)this.entries.get((Object)nodeId);
            if (Objects.nonNull(lockableFromState)) {
                this.entryCache.put((Object)nodeId, (Object)lockableFromState);
            }
            return lockableFromState;
        }
        catch (Exception ex) {
            throw new WrappingRuntimeException((Throwable)ex);
        }
    }

    Lockable<V> getEvent(EventId eventId) {
        try {
            Lockable lockableFromCache = (Lockable)this.eventsBufferCache.getIfPresent((Object)eventId);
            if (Objects.nonNull(lockableFromCache)) {
                return lockableFromCache;
            }
            Lockable lockableFromState = (Lockable)this.eventsBuffer.get((Object)eventId);
            if (Objects.nonNull(lockableFromState)) {
                this.eventsBufferCache.put((Object)eventId, (Object)lockableFromState);
            }
            return lockableFromState;
        }
        catch (Exception ex) {
            throw new WrappingRuntimeException((Throwable)ex);
        }
    }

    void flushCache() throws Exception {
        if (!this.entryCache.asMap().isEmpty()) {
            this.entries.putAll((Map)this.entryCache.asMap());
            this.entryCache.invalidateAll();
        }
        if (!this.eventsBufferCache.asMap().isEmpty()) {
            this.eventsBuffer.putAll((Map)this.eventsBufferCache.asMap());
            this.eventsBufferCache.invalidateAll();
        }
    }

    @VisibleForTesting
    Iterator<Map.Entry<Long, Integer>> getEventCounters() throws Exception {
        return this.eventsCount.iterator();
    }

    @VisibleForTesting
    public int getEventsBufferCacheSize() {
        return (int)this.eventsBufferCache.size();
    }

    @VisibleForTesting
    public int getEventsBufferSize() throws Exception {
        return Iterables.size((Iterable)this.eventsBuffer.entries());
    }

    @VisibleForTesting
    public int getSharedBufferNodeSize() throws Exception {
        return Iterables.size((Iterable)this.entries.entries());
    }

    @VisibleForTesting
    public int getSharedBufferNodeCacheSize() throws Exception {
        return (int)this.entryCache.size();
    }
}

